/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.Serializable;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.factory.primitive.ObjectFloatMaps;
import org.eclipse.collections.api.map.primitive.MutableObjectFloatMap;
import org.neo4j.batchimport.api.IndexesCreator;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.KernelException;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.index.BulkIndexCreationContext;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;

public class BulkIndexesCreator
implements IndexesCreator {
    private final Config config;
    private final ReadableStorageEngine storageEngine;
    private final DatabaseLayout databaseLayout;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final MetadataCache metadataCache;
    private final JobScheduler jobScheduler;
    private final TokenHolders tokenHolders;
    private final ElementIdMapper elementIdMapper;
    private final CursorContextFactory contextFactory;
    private final PageCacheTracer pageCacheTracer;
    private final LogService logService;
    private final MemoryTracker memoryTracker;

    public BulkIndexesCreator(BulkIndexCreationContext context) {
        this.config = Objects.requireNonNull(context).config();
        this.storageEngine = context.storageEngine();
        this.databaseLayout = context.databaseLayout();
        this.fileSystem = context.fileSystem();
        this.pageCache = context.pageCache();
        this.metadataCache = context.metadataCache();
        this.jobScheduler = context.jobScheduler();
        this.tokenHolders = context.tokenHolders();
        this.elementIdMapper = context.elementIdMapper();
        this.contextFactory = context.contextFactory();
        this.pageCacheTracer = context.pageCacheTracer();
        this.logService = context.logService();
        this.memoryTracker = context.memoryTracker();
    }

    public void create(IndexesCreator.CreationListener creationListener, List<IndexDescriptor> indexDescriptors) throws IOException {
        block23: {
            int descriptorCount = indexDescriptors.size();
            if (descriptorCount == 0) {
                return;
            }
            try (CursorContext creationContext = this.contextFactory.create("Indexing creation");
                 Lifespan life = Lifespan.createWithNoneState((Lifecycle[])new Lifecycle[0]);){
                IndexingService indexingService = this.indexingService((LifeSupport)life);
                life.start();
                indexingService.createIndexes(Subject.SYSTEM, (IndexDescriptor[])indexDescriptors.stream().map(indexingService::completeConfiguration).toArray(IndexDescriptor[]::new));
                MutableObjectFloatMap progressTracker = ObjectFloatMaps.mutable.empty();
                int completed = 0;
                int failed = 0;
                while (completed + failed < descriptorCount) {
                    for (IndexProxy indexProxy : indexingService.getIndexProxies()) {
                        InternalIndexState state;
                        float latestProgress;
                        IndexDescriptor descriptor = indexProxy.getDescriptor();
                        float updatedValue = progressTracker.updateValue((Object)descriptor, latestProgress = indexProxy.getIndexPopulationProgress().getProgress(), (FloatToFloatFunction & Serializable)lastProgress -> {
                            creationListener.onUpdate(descriptor, latestProgress - lastProgress);
                            return latestProgress;
                        });
                        if (updatedValue == latestProgress && latestProgress > 0.0f) {
                            creationListener.onUpdate(descriptor, latestProgress);
                        }
                        if ((state = indexProxy.getState()) == InternalIndexState.FAILED) {
                            ++failed;
                            creationListener.onFailure(descriptor, (KernelException)indexProxy.getPopulationFailure().asIndexPopulationFailure(descriptor.schema(), descriptor.userDescription((TokenNameLookup)this.tokenHolders)));
                            continue;
                        }
                        if (state != InternalIndexState.ONLINE && latestProgress != 1.0f) continue;
                        ++completed;
                    }
                    BulkIndexesCreator.sleepIgnoreInterrupt();
                }
                boolean success = failed == 0;
                creationListener.onCreationCompleted(success);
                if (!success) break block23;
                try (DatabaseFlushEvent flushEvent = this.pageCacheTracer.beginDatabaseFlush();){
                    indexingService.checkpoint(flushEvent, creationContext);
                    creationListener.onCheckpointingCompleted();
                }
            }
        }
    }

    private IndexingService indexingService(LifeSupport life) throws IOException {
        SystemNanoClock clock = Clocks.nanoClock();
        InternalLogProvider logProvider = this.logService.getInternalLogProvider();
        DatabaseSchemaState schemaState = new DatabaseSchemaState(logProvider);
        GroupingRecoveryCleanupWorkCollector cleanupCollector = (GroupingRecoveryCleanupWorkCollector)life.add((Lifecycle)new GroupingRecoveryCleanupWorkCollector(this.jobScheduler, Group.INDEX_POPULATION, Group.INDEX_POPULATION_WORK, this.databaseLayout.getDatabaseName()));
        DatabaseReadOnlyChecker readOnlyChecker = DatabaseReadOnlyChecker.writable();
        Dependencies indexDependencies = new Dependencies();
        indexDependencies.satisfyDependencies(new Object[]{VersionStorage.EMPTY_STORAGE});
        StaticIndexProviderMap indexProviderMap = (StaticIndexProviderMap)life.add((Lifecycle)StaticIndexProviderMapFactory.create(life, this.config, this.pageCache, this.fileSystem, this.logService, new Monitors(), readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode.SINGLE, (RecoveryCleanupWorkCollector)cleanupCollector, this.databaseLayout, this.tokenHolders, this.jobScheduler, this.contextFactory, this.pageCacheTracer, (DependencyResolver)indexDependencies));
        FullScanStoreView fullScanStoreView = new FullScanStoreView(LockService.NO_LOCK_SERVICE, this.storageEngine, this.config, this.jobScheduler);
        IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory(this.config, this.storageEngine, LockManager.NO_LOCKS_LOCK_MANAGER, fullScanStoreView, LockService.NO_LOCK_SERVICE, logProvider);
        IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)life.add((Lifecycle)new IndexStatisticsStore(this.pageCache, this.fileSystem, this.databaseLayout.indexStatisticsStore(), RecoveryCleanupWorkCollector.immediate(), false, this.databaseLayout.getDatabaseName(), this.contextFactory, this.pageCacheTracer, this.storageEngine.getOpenOptions()));
        return (IndexingService)life.add((Lifecycle)IndexingServiceFactory.createIndexingService(this.storageEngine, this.config, this.jobScheduler, indexProviderMap, indexStoreViewFactory, (TokenNameLookup)this.tokenHolders, this.elementIdMapper, List.of(), this.logService.getInternalLogProvider(), IndexMonitor.NO_MONITOR, schemaState, indexStatisticsStore, new DatabaseIndexStats(), this.contextFactory, this.memoryTracker, this.databaseLayout.getDatabaseName(), readOnlyChecker, (Clock)clock, (KernelVersionProvider)this.metadataCache, this.fileSystem, TransactionVisibilityProvider.EMPTY_VISIBILITY_PROVIDER));
    }

    private static void sleepIgnoreInterrupt() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

