/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModelUtil;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class CommunityTopologyGraphDbmsModel
implements TopologyGraphDbmsModel {
    protected final Transaction tx;

    public CommunityTopologyGraphDbmsModel(Transaction tx) {
        this.tx = tx;
    }

    public Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> getAllDatabaseAccess() {
        try (ResourceIterator nodes = this.tx.findNodes(DATABASE_LABEL);){
            Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> map = nodes.stream().collect(Collectors.toMap(CommunityTopologyGraphDbmsModelUtil::getDatabaseId, CommunityTopologyGraphDbmsModelUtil::getDatabaseAccess));
            return map;
        }
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.getDatabaseIdByAlias(this.tx, databaseName).or(() -> CommunityTopologyGraphDbmsModelUtil.getDatabaseIdBy(this.tx, "name", databaseName));
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID uuid) {
        return CommunityTopologyGraphDbmsModelUtil.getDatabaseIdBy(this.tx, "uuid", uuid.toString());
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        Stream<DatabaseReferenceImpl.Internal> primaryRefs = CommunityTopologyGraphDbmsModelUtil.getAllPrimaryStandardDatabaseReferencesInRoot(this.tx);
        Stream<DatabaseReferenceImpl.Internal> internalAliasRefs = this.getAllInternalDatabaseReferencesInRoot();
        Stream<DatabaseReferenceImpl.External> externalRefs = this.getAllExternalDatabaseReferencesInRoot();
        Stream<DatabaseReferenceImpl.Composite> compositeRefs = this.getAllCompositeDatabaseReferencesInRoot();
        Stream<DatabaseReferenceImpl.SPD> spdEntityShardRefs = this.getAllSPDEntityShardReferencesInRoot();
        Stream<DatabaseReferenceImpl.SPDShard> spdPropertyShardRefs = this.getAllSPDPropertyShardReferencesInRoot();
        return Stream.of(primaryRefs, internalAliasRefs, externalRefs, compositeRefs, spdEntityShardRefs, spdPropertyShardRefs).flatMap(s -> s).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReferenceImpl.Internal> getAllInternalDatabaseReferences() {
        Stream<DatabaseReferenceImpl.Internal> primaryRefs = CommunityTopologyGraphDbmsModelUtil.getAllPrimaryStandardDatabaseReferencesInRoot(this.tx);
        Stream<DatabaseReferenceImpl.Internal> internalAliasRefs = this.getAllInternalDatabaseReferencesInRoot();
        Stream<DatabaseReferenceImpl.SPD> spdEntityShardRefs = this.getAllSPDEntityShardReferencesInRoot();
        Stream<DatabaseReferenceImpl.SPDShard> spdPropertyShardRefs = this.getAllSPDPropertyShardReferencesInRoot();
        return Stream.of(primaryRefs, internalAliasRefs, spdEntityShardRefs, spdPropertyShardRefs).flatMap(s -> s).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReferenceImpl.External> getAllExternalDatabaseReferences() {
        return this.getAllExternalDatabaseReferencesInRoot().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReferenceImpl.Composite> getAllCompositeDatabaseReferences() {
        return this.getAllCompositeDatabaseReferencesInRoot().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<DatabaseReference> getDatabaseRefByAlias(String databaseName) {
        String normalizedDatabaseName = new NormalizedDatabaseName(databaseName).name();
        return Optional.empty().or(() -> this.getCompositeDatabaseReferenceInRoot(normalizedDatabaseName)).or(() -> this.getSPDEntityShardReferenceInRoot(normalizedDatabaseName)).or(() -> this.getSPDPropertyShardReferenceInRoot(normalizedDatabaseName)).or(() -> CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReference(this.tx, normalizedDatabaseName)).or(() -> CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReference(this.tx, normalizedDatabaseName));
    }

    @Override
    public Optional<DatabaseReference> getDatabaseRefByAlias(NormalizedCatalogEntry catalogEntry) {
        if (catalogEntry.compositeDb().isPresent()) {
            return this.resolveConstituent((String)catalogEntry.compositeDb().get(), catalogEntry.databaseAlias());
        }
        return this.resolveRootReference(catalogEntry.databaseAlias());
    }

    private Optional<DatabaseReference> resolveConstituent(String composite, String constituent) {
        return Optional.empty().or(() -> CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReference(this.tx, composite, constituent)).or(() -> CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReference(this.tx, composite, constituent));
    }

    private Optional<DatabaseReference> resolveRootReference(String normalizedDatabaseAlias) {
        return Optional.empty().or(() -> this.getCompositeDatabaseReferenceInRoot(normalizedDatabaseAlias)).or(() -> this.getSPDEntityShardReferenceInRoot(normalizedDatabaseAlias)).or(() -> this.getSPDPropertyShardReferenceInRoot(normalizedDatabaseAlias)).or(() -> CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReference(this.tx, normalizedDatabaseAlias)).or(() -> CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReference(this.tx, normalizedDatabaseAlias));
    }

    @Override
    public Optional<DriverSettings> getDriverSettings(String databaseName, String namespace) {
        databaseName = new NormalizedDatabaseName(databaseName).name();
        namespace = new NormalizedDatabaseName(namespace).name();
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getDriverSettings);
    }

    @Override
    public Optional<Map<String, Object>> getAliasProperties(String databaseName, String namespace) {
        databaseName = new NormalizedDatabaseName(databaseName).name();
        namespace = new NormalizedDatabaseName(namespace).name();
        return this.tx.findNodes(DATABASE_NAME_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getAliasProperties);
    }

    @Override
    public Optional<ExternalDatabaseCredentials> getExternalDatabaseCredentials(DatabaseReferenceImpl.External databaseReference) {
        String databaseName = databaseReference.alias().name();
        String namespace = databaseReference.namespace().map(NormalizedDatabaseName::name).orElse("system-root");
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getDatabaseCredentials);
    }

    private Stream<DatabaseReferenceImpl.Composite> getAllCompositeDatabaseReferencesInRoot() {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root").flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(COMPOSITE_DATABASE_LABEL)).flatMap(db -> this.createCompositeReference((Node)alias, (Node)db)).stream());
    }

    private Optional<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferenceInRoot(String databaseName) {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root", databaseName).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(COMPOSITE_DATABASE_LABEL)).flatMap(db -> this.createCompositeReference((Node)alias, (Node)db)).stream()).findFirst();
    }

    private Optional<DatabaseReferenceImpl.Composite> createCompositeReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE_NAME, alias);
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            NormalizedDatabaseName compositeName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE, db);
            Set<DatabaseReference> components = this.getAllDatabaseReferencesInComposite(compositeName);
            return Optional.of(new DatabaseReferenceImpl.Composite(aliasName, databaseId, components));
        });
    }

    private Stream<DatabaseReferenceImpl.SPD> getAllSPDEntityShardReferencesInRoot() {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root").flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.getDegree(HAS_SHARD, Direction.OUTGOING) > 0).flatMap(db -> this.createSPDEntityShardReference((Node)alias, (Node)db)).stream());
    }

    private Optional<DatabaseReferenceImpl.SPD> getSPDEntityShardReferenceInRoot(String databaseName) {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root", databaseName).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.getDegree(HAS_SHARD, Direction.OUTGOING) > 0).flatMap(db -> this.createSPDEntityShardReference((Node)alias, (Node)db)).stream()).findFirst();
    }

    private Stream<DatabaseReferenceImpl.SPDShard> getAllSPDPropertyShardReferencesInRoot() {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root").flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.getDegree(HAS_SHARD, Direction.INCOMING) > 0).flatMap(db -> CommunityTopologyGraphDbmsModel.createSPDPropertyShardReference(alias, db)).stream());
    }

    private Optional<DatabaseReferenceImpl.SPDShard> getSPDPropertyShardReferenceInRoot(String databaseName) {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, "system-root", databaseName).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.getDegree(HAS_SHARD, Direction.INCOMING) > 0).flatMap(db -> CommunityTopologyGraphDbmsModel.createSPDPropertyShardReference(alias, db)).stream()).findFirst();
    }

    private Optional<DatabaseReferenceImpl.SPD> createSPDEntityShardReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE_NAME, alias);
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            Map<Integer, DatabaseReference> shards = StreamSupport.stream(db.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.HAS_SHARD}).spliterator(), false).flatMap(rel -> this.getDatabaseRefByAlias((String)rel.getEndNode().getProperty("name")).map(ref -> Pair.of((Object)((Integer)rel.getProperty("index")), (Object)ref)).stream()).collect(Collectors.toMap(Pair::first, Pair::other));
            return Optional.of(new DatabaseReferenceImpl.SPD(aliasName, databaseId, shards));
        });
    }

    private static Optional<DatabaseReferenceImpl.SPDShard> createSPDPropertyShardReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db)).flatMap(internal -> CommunityTopologyGraphDbmsModelUtil.readOwningDatabase(db).map(internal::asShard));
    }

    private Stream<Node> getAliasNodesInNamespace(Label label, String namespace) {
        return this.tx.findNodes(label, "namespace", (Object)namespace).stream();
    }

    private Stream<Node> getAliasNodesInNamespace(Label label, String namespace, String databaseName) {
        return this.tx.findNodes(label, "namespace", (Object)namespace, "name", (Object)databaseName).stream();
    }

    private Set<DatabaseReference> getAllDatabaseReferencesInComposite(NormalizedDatabaseName compositeName) {
        Stream<DatabaseReferenceImpl.Internal> internalRefs = this.getAllInternalDatabaseReferencesInNamespace(compositeName.name());
        Stream<DatabaseReferenceImpl.External> externalRefs = this.getAllExternalDatabaseReferencesInNamespace(compositeName.name());
        return Stream.concat(internalRefs, externalRefs).collect(Collectors.toUnmodifiableSet());
    }

    private Stream<DatabaseReferenceImpl.External> getAllExternalDatabaseReferencesInRoot() {
        return this.getAllExternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReferenceImpl.External> getAllExternalDatabaseReferencesInNamespace(String namespace) {
        return this.getAliasNodesInNamespace(REMOTE_DATABASE_LABEL, namespace).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.createExternalReference(alias).stream());
    }

    private Stream<DatabaseReferenceImpl.Internal> getAllInternalDatabaseReferencesInRoot() {
        return this.getAllInternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReferenceImpl.Internal> getAllInternalDatabaseReferencesInNamespace(String namespace) {
        return this.getAliasNodesInNamespace(DATABASE_NAME_LABEL, namespace).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(node -> !node.hasProperty("virtual")).filter(node -> node.getDegree(HAS_SHARD, Direction.OUTGOING) == 0 && node.getDegree(HAS_SHARD, Direction.INCOMING) == 0).map(CommunityTopologyGraphDbmsModelUtil::getDatabaseId).flatMap(db -> CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, db)).stream());
    }
}

