/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.FileStoreProviderRegistry;
import org.neo4j.kernel.impl.store.SchemaAndIndexingFileIndexListing;
import org.neo4j.kernel.impl.store.StoreFileProvider;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.util.MultiResource;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class StoreFileListing
implements FileStoreProviderRegistry {
    private final DatabaseLayout databaseLayout;
    private final LogFiles logFiles;
    private final StorageEngine storageEngine;
    private static final Function<Path, StoreFileMetadata> logFileMapper = path -> new StoreFileMetadata(path, true);
    private final SchemaAndIndexingFileIndexListing fileIndexListing;
    private final Collection<StoreFileProvider> additionalProviders;

    public StoreFileListing(DatabaseLayout databaseLayout, LogFiles logFiles, IndexingService indexingService, StorageEngine storageEngine) {
        this.databaseLayout = databaseLayout;
        this.logFiles = logFiles;
        this.storageEngine = storageEngine;
        this.fileIndexListing = new SchemaAndIndexingFileIndexListing(indexingService);
        this.additionalProviders = new CopyOnWriteArraySet<StoreFileProvider>();
    }

    public Builder builder() {
        return new Builder();
    }

    @Override
    public void registerStoreFileProvider(StoreFileProvider provider) {
        this.additionalProviders.add(provider);
    }

    private void placeMetaDataStoreLast(List<StoreFileMetadata> files) {
        int index = 0;
        for (StoreFileMetadata file : files) {
            if (this.databaseLayout.pathForStore(CommonDatabaseStores.METADATA).equals(file.path())) break;
            ++index;
        }
        if (index < files.size() - 1) {
            StoreFileMetadata metaDataStoreFile = files.remove(index);
            files.add(metaDataStoreFile);
        }
    }

    private void gatherLogFiles(Collection<StoreFileMetadata> files) throws IOException {
        Path[] list;
        for (Path logFile : list = this.logFiles.logFiles()) {
            files.add(logFileMapper.apply(logFile));
        }
    }

    private void gatherIdFiles(List<StoreFileMetadata> targetFiles) {
        this.storageEngine.listIdFiles(targetFiles);
    }

    private void gatherStorageFiles(Collection<StoreFileMetadata> targetFiles, boolean gatherAtomic, boolean gatherReplayable) {
        ArrayList atomic = new ArrayList();
        ArrayList replayable = new ArrayList();
        this.storageEngine.listStorageFiles(atomic, replayable);
        if (gatherAtomic) {
            targetFiles.addAll(atomic);
        }
        if (gatherReplayable) {
            targetFiles.addAll(replayable);
        }
    }

    public class Builder {
        private boolean excludeLogFiles;
        private boolean excludeAtomicStorageFiles;
        private boolean excludeReplayableStorageFiles;
        private boolean excludeSchemaIndexStoreFiles;
        private boolean excludeAdditionalProviders;
        private boolean excludeIdFiles;

        private Builder() {
        }

        private void excludeAll(boolean initiateInclusive) {
            this.excludeLogFiles = initiateInclusive;
            this.excludeAtomicStorageFiles = initiateInclusive;
            this.excludeReplayableStorageFiles = initiateInclusive;
            this.excludeSchemaIndexStoreFiles = initiateInclusive;
            this.excludeAdditionalProviders = initiateInclusive;
            this.excludeIdFiles = initiateInclusive;
        }

        public Builder excludeAll() {
            this.excludeAll(true);
            return this;
        }

        public Builder includeAll() {
            this.excludeAll(false);
            return this;
        }

        public Builder excludeLogFiles() {
            this.excludeLogFiles = true;
            return this;
        }

        public Builder excludeAtomicStorageFiles() {
            this.excludeAtomicStorageFiles = true;
            return this;
        }

        public Builder excludeReplayableStorageFiles() {
            this.excludeReplayableStorageFiles = true;
            return this;
        }

        public Builder excludeSchemaIndexStoreFiles() {
            this.excludeSchemaIndexStoreFiles = true;
            return this;
        }

        public Builder excludeAdditionalProviders() {
            this.excludeAdditionalProviders = true;
            return this;
        }

        public Builder excludeIdFiles() {
            this.excludeIdFiles = true;
            return this;
        }

        public Builder includeLogFiles() {
            this.excludeLogFiles = false;
            return this;
        }

        public Builder includeAtomicStorageFiles() {
            this.excludeAtomicStorageFiles = false;
            return this;
        }

        public Builder includeReplayableStorageFiles() {
            this.excludeReplayableStorageFiles = false;
            return this;
        }

        public Builder includeSchemaIndexStoreFiles() {
            this.excludeSchemaIndexStoreFiles = false;
            return this;
        }

        public Builder includeAdditionalProviders() {
            this.excludeAdditionalProviders = false;
            return this;
        }

        public Builder includeIdFiles() {
            this.excludeIdFiles = false;
            return this;
        }

        public ResourceIterator<StoreFileMetadata> build() throws IOException {
            ArrayList<StoreFileMetadata> files = new ArrayList<StoreFileMetadata>();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            try {
                if (!this.excludeLogFiles) {
                    StoreFileListing.this.gatherLogFiles(files);
                }
                if (!this.excludeAtomicStorageFiles || !this.excludeReplayableStorageFiles) {
                    StoreFileListing.this.gatherStorageFiles(files, !this.excludeAtomicStorageFiles, !this.excludeReplayableStorageFiles);
                }
                if (!this.excludeIdFiles) {
                    StoreFileListing.this.gatherIdFiles(files);
                }
                if (!this.excludeSchemaIndexStoreFiles) {
                    resources.add(StoreFileListing.this.fileIndexListing.gatherSchemaIndexFiles(files));
                }
                if (!this.excludeAdditionalProviders) {
                    for (StoreFileProvider additionalProvider : StoreFileListing.this.additionalProviders) {
                        resources.add(additionalProvider.addFilesTo(files));
                    }
                }
                StoreFileListing.this.placeMetaDataStoreLast(files);
            }
            catch (IOException e) {
                try {
                    IOUtils.closeAll(resources);
                }
                catch (IOException e1) {
                    throw (IOException)Exceptions.chain((Throwable)e, (Throwable)e1);
                }
                throw e;
            }
            return Iterators.resourceIterator(files.iterator(), (Resource)new MultiResource(resources));
        }
    }
}

