/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.neo4j.configuration.SettingValueParsers;

public class ThresholdConfigParser {
    private ThresholdConfigParser() {
    }

    public static ThresholdConfigValue parse(String configValue) {
        String[] tokens = configValue.split(" ");
        if (tokens.length == 0) {
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'");
        }
        String boolOrNumber = tokens[0];
        if (tokens.length == 1) {
            return switch (boolOrNumber) {
                case "keep_all", "true" -> ThresholdConfigValue.NO_PRUNING;
                case "keep_none", "false" -> ThresholdConfigValue.KEEP_LAST_FILE;
                default -> throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'. The form is 'true', 'false' or '<number><unit> <type>'. For example, '100k txs' will keep the 100 000 latest transactions.");
            };
        }
        long thresholdValue = SettingValueParsers.parseLongWithUnit((String)boolOrNumber);
        String thresholdType = tokens[1];
        long maxSizeRestriction = tokens.length > 2 ? SettingValueParsers.parseLongWithUnit((String)tokens[2]) : -1L;
        return new ThresholdConfigValue(thresholdType, thresholdValue, maxSizeRestriction);
    }

    public record ThresholdConfigValue(String type, long value, long additionalRestriction) {
        private static final long NO_ADDITIONAL_RESTRICTION = -1L;
        static final ThresholdConfigValue NO_PRUNING = new ThresholdConfigValue("false", -1L, -1L);
        static final ThresholdConfigValue KEEP_LAST_FILE = new ThresholdConfigValue("entries", 1L, -1L);

        ThresholdConfigValue(String type, long value) {
            this(type, value, -1L);
        }

        boolean hasAdditionalRestriction() {
            return this.additionalRestriction != -1L;
        }
    }
}

