/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.util.InconsistentTransactionLogException;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class TransactionLogChecker {
    private TransactionLogChecker() {
    }

    public static void verifyCorrectTransactionLogUpgrades(FileSystemAbstraction fs, DatabaseLayout layout, Config config) throws IOException, InconsistentTransactionLogException {
        LogFiles logFiles = LogFilesBuilder.readOnlyBuilder(layout, fs, KernelVersionProvider.THROWING_PROVIDER).build();
        LogFile logFile = logFiles.getLogFile();
        Optional storageEngineFactory = StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)layout);
        CommandReaderFactory commandReaderFactory = ((StorageEngineFactory)storageEngineFactory.orElseThrow(() -> new IllegalStateException("Couldn't figure out storage engine from store files"))).commandReaderFactory();
        KernelVersion versionSeen = KernelVersion.EARLIEST;
        for (long i = logFile.getLowestLogVersion(); i <= logFile.getHighestLogVersion(); ++i) {
            LogHeader logHeader = LogHeaderReader.readLogHeader(fs, logFiles.getLogFile().getLogFileForVersion(i), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            if (logHeader == null) {
                throw new InconsistentTransactionLogException("Could not read log header of log file version %d".formatted(i));
            }
            KernelVersion logHeaderKernelVersion = logHeader.getKernelVersion();
            if (TransactionLogChecker.versionLessThan(logHeaderKernelVersion, versionSeen)) {
                throw new InconsistentTransactionLogException("Log file version %d contains entry with lower kernel version (%s) than version seen in file with version %d (%s)".formatted(i, logHeaderKernelVersion.name(), i - 1L, versionSeen.name()));
            }
            versionSeen = TransactionLogChecker.verifyVersionInOneFile(logHeader, logFile, logHeaderKernelVersion, versionSeen, commandReaderFactory, config, logFiles.getCheckpointFile());
        }
    }

    private static KernelVersion verifyVersionInOneFile(LogHeader logHeader, LogFile logFile, KernelVersion logHeaderKernelVersion, KernelVersion previouslySeenVersion, CommandReaderFactory commandReaderFactory, Config config, CheckpointFile checkpointFile) throws IOException {
        KernelVersion versionSeenInFile;
        KernelVersion kernelVersion = versionSeenInFile = logHeader.getLogFormatVersion().usesSegments() ? TransactionLogChecker.verifyVersionInSegmentedFile(logFile, logHeader, logHeaderKernelVersion) : TransactionLogChecker.verifyVersionInOldFile(logFile, logHeader, logHeaderKernelVersion, commandReaderFactory, config, checkpointFile);
        if (logHeaderKernelVersion == null && TransactionLogChecker.versionLessThan(versionSeenInFile, previouslySeenVersion)) {
            throw new InconsistentTransactionLogException("Log file version %d contains entry with lower kernel version (%s) than version seen in previous file (%s)".formatted(logHeader.getLogVersion(), versionSeenInFile.name(), previouslySeenVersion.name()));
        }
        return versionSeenInFile != null ? versionSeenInFile : (logHeaderKernelVersion != null ? logHeaderKernelVersion : previouslySeenVersion);
    }

    private static boolean versionLessThan(KernelVersion version, KernelVersion comparable) {
        return version != null && comparable != null && version.isLessThan(comparable);
    }

    public static KernelVersion verifyVersionInSegmentedFile(LogFile logFile, LogHeader logHeader, KernelVersion expectedVersion) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = logFile.openForVersion(logHeader.getLogVersion(), false);
        logChannel.position(logHeader.getStartPosition().getByteOffset());
        try (VersionCheckingEnvelopeReadChannel versionCheckingEnvelopeReadChannel = new VersionCheckingEnvelopeReadChannel((LogVersionedStoreChannel)logChannel, logHeader.getSegmentBlockSize(), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE, false, expectedVersion);){
            if (TransactionLogChecker.findEnvelopeVersionErrors(versionCheckingEnvelopeReadChannel)) {
                throw new InconsistentTransactionLogException("Log file version %d malformed, could not read until end".formatted(logHeader.getLogVersion()));
            }
            KernelVersion kernelVersion = versionCheckingEnvelopeReadChannel.expectedVersion;
            return kernelVersion;
        }
    }

    private static boolean findEnvelopeVersionErrors(VersionCheckingEnvelopeReadChannel versionCheckingEnvelopeReadChannel) throws IOException {
        long prevPos = -1L;
        try {
            long pos;
            while (prevPos < (pos = versionCheckingEnvelopeReadChannel.goToNextEntry())) {
                prevPos = pos;
            }
        }
        catch (ReadPastEndException e) {
            return false;
        }
        return true;
    }

    public static KernelVersion verifyVersionInOldFile(LogFile logFile, LogHeader logHeader, KernelVersion expectedVersion, CommandReaderFactory commandReaderFactory, Config config, CheckpointFile checkpointFile) throws IOException {
        KernelVersion seenVersion = expectedVersion;
        try (ReadableLogChannel reader = logFile.getReader(logHeader.getStartPosition(), LogVersionBridge.NO_MORE_CHANNELS);){
            LogEntry entry;
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(commandReaderFactory, new BinarySupportedKernelVersions(config));
            long lastSeenTxId = -1L;
            while ((entry = entryReader.readLogEntry((ReadableLogPositionAwareChannel)reader)) != null) {
                if (entry instanceof LogEntryStart) {
                    LogEntryStart start = (LogEntryStart)entry;
                    KernelVersion startVersion = start.kernelVersion();
                    if (seenVersion == null) {
                        seenVersion = startVersion;
                    } else if (seenVersion != startVersion) {
                        if (startVersion.isLessThan(seenVersion)) {
                            throw new InconsistentTransactionLogException("Log file version %d contains entry with lower kernel version (%s) than version seen earlier in the file (%s)".formatted(logHeader.getLogVersion(), startVersion.name(), seenVersion.name()));
                        }
                        long upgradeTxId = lastSeenTxId;
                        if (checkpointFile.reachableCheckpoints().stream().map(c -> c.transactionId().id()).noneMatch(id -> id == upgradeTxId)) {
                            throw new InconsistentTransactionLogException("Log file version %d contains entry with other kernel version (%s) than version seen earlier in the file (%s)".formatted(logHeader.getLogVersion(), startVersion.name(), seenVersion.name()));
                        }
                        seenVersion = startVersion;
                    }
                }
                if (!(entry instanceof LogEntryCommit)) continue;
                LogEntryCommit commit = (LogEntryCommit)entry;
                lastSeenTxId = commit.getTxId();
            }
        }
        return seenVersion;
    }

    static class VersionCheckingEnvelopeReadChannel
    extends EnvelopeReadChannel {
        private final long logVersion;
        private KernelVersion expectedVersion;
        private byte expectedVersionByte;

        protected VersionCheckingEnvelopeReadChannel(LogVersionedStoreChannel startingChannel, int segmentBlockSize, LogVersionBridge bridge, MemoryTracker memoryTracker, boolean raw, KernelVersion expectedVersion) throws IOException {
            super(startingChannel, segmentBlockSize, bridge, memoryTracker, raw);
            this.logVersion = startingChannel.getLogVersion();
            this.expectedVersion = expectedVersion;
            this.expectedVersionByte = (byte)(expectedVersion != null ? (int)expectedVersion.version() : -1);
        }

        protected void readEnvelopeHeader() throws IOException {
            super.readEnvelopeHeader();
            if (this.expectedVersion == null) {
                this.expectedVersion = KernelVersion.getForVersion((byte)this.payloadVersion);
                this.expectedVersionByte = this.payloadVersion;
            } else if (this.expectedVersionByte != this.payloadVersion) {
                throw new InconsistentTransactionLogException("Log file version %d contains entry with other kernel version (%s) than version seen earlier in the file (%s)".formatted(this.logVersion, KernelVersion.getForVersion((byte)this.payloadVersion).name(), this.expectedVersion.name()));
            }
        }
    }
}

