/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.DelegatingMemoryPool;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.ExecutionContextMemoryTracker;
import org.neo4j.memory.HighWaterMarkMemoryPool;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPoolImpl;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;

public class TransactionMemoryPool
extends DelegatingMemoryPool
implements ScopedMemoryPool {
    private final ScopedMemoryPool delegate;
    private final Config config;
    private final BooleanSupplier openCheck;
    private final LogProvider logProvider;
    private final LocalMemoryTracker transactionTracker;
    private final AtomicReference<HighWaterMarkMemoryPool> heapHighWaterMarkPool = new AtomicReference();
    private volatile boolean hasExecutionContextMemoryTrackers = false;

    public TransactionMemoryPool(ScopedMemoryPool delegate, Config config, BooleanSupplier openCheck, LogProvider logProvider) {
        super((MemoryPool)new MemoryPoolImpl(delegate.totalSize(), true, GraphDatabaseSettings.memory_transaction_max_size.name()));
        this.delegate = delegate;
        this.config = config;
        this.openCheck = openCheck;
        this.logProvider = logProvider;
        this.transactionTracker = this.createMemoryTracker();
    }

    public MemoryGroup group() {
        return this.delegate.group();
    }

    public void close() {
        this.reset();
    }

    public LocalMemoryTracker getTransactionTracker() {
        return this.transactionTracker;
    }

    public MemoryTracker getPoolMemoryTracker() {
        throw new UnsupportedOperationException("Use getExecutionContextPoolMemoryTracker instead");
    }

    public MemoryTracker getExecutionContextPoolMemoryTracker(long grabSize, long maxGrabSize) {
        if (((Boolean)this.config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()) {
            this.hasExecutionContextMemoryTrackers = true;
            return this.createExecutionContextMemoryTracker(grabSize, maxGrabSize);
        }
        return EmptyMemoryTracker.INSTANCE;
    }

    public void reserveHeap(long bytes) {
        this.delegate.reserveHeap(bytes);
        try {
            super.reserveHeap(bytes);
        }
        catch (MemoryLimitExceededException e) {
            this.delegate.releaseHeap(bytes);
            throw e;
        }
    }

    public void releaseHeap(long bytes) {
        super.releaseHeap(bytes);
        this.delegate.releaseHeap(bytes);
    }

    public void reserveNative(long bytes) {
        this.delegate.reserveNative(bytes);
        try {
            super.reserveNative(bytes);
        }
        catch (MemoryLimitExceededException e) {
            this.delegate.releaseNative(bytes);
            throw e;
        }
    }

    public void releaseNative(long bytes) {
        super.releaseNative(bytes);
        this.delegate.releaseNative(bytes);
    }

    private LocalMemoryTracker createMemoryTracker() {
        return new LocalMemoryTracker((MemoryPool)this, 0L, ((Long)this.config.get(GraphDatabaseInternalSettings.initial_transaction_heap_grab_size)).longValue(), GraphDatabaseSettings.memory_transaction_max_size.name(), this.openCheck, TransactionMemoryPool.memoryLeakLogger(this.logProvider.getLog(((Object)((Object)this)).getClass())));
    }

    private HighWaterMarkMemoryPool highWaterMarkMemoryPool() {
        HighWaterMarkMemoryPool pool = this.heapHighWaterMarkPool.get();
        if (pool == null) {
            pool = new HighWaterMarkMemoryPool((MemoryPool)this);
            this.heapHighWaterMarkPool.compareAndSet(null, pool);
        }
        return pool;
    }

    private ExecutionContextMemoryTracker createExecutionContextMemoryTracker(long grabSize, long maxGrabSize) {
        return new ExecutionContextMemoryTracker(this.highWaterMarkMemoryPool(), 0L, grabSize, maxGrabSize, GraphDatabaseSettings.memory_transaction_max_size.name(), this.openCheck);
    }

    private static LocalMemoryTracker.Monitor memoryLeakLogger(Log log) {
        return leakedNativeMemoryBytes -> log.warn("Potential direct memory leak. Expecting all allocated direct memory to be released, but still has " + leakedNativeMemoryBytes);
    }

    public void setLimit(long transactionHeapBytesLimit) {
        this.setSize(transactionHeapBytesLimit);
    }

    public void reset() {
        HighWaterMarkMemoryPool highWaterMarkMemoryPool;
        this.transactionTracker.reset();
        if (this.hasExecutionContextMemoryTrackers) {
            this.releaseHeap(this.usedHeap());
            this.hasExecutionContextMemoryTrackers = false;
        }
        if ((highWaterMarkMemoryPool = this.heapHighWaterMarkPool.get()) != null) {
            highWaterMarkMemoryPool.reset();
        }
        assert (this.usedNative() == 0L) : "Potential direct memory leak. Expecting all allocated direct memory to be released, but still has " + this.usedNative();
        assert (this.usedHeap() == 0L) : "Heap memory leak. Expecting all allocated memory to be released, but still has " + this.usedHeap();
    }
}

