/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.storageengine.api.PropertySelection;

public abstract class AbstractEntity
implements Entity {
    protected boolean hasProperty(String key, EntityCursor singleEntity, PropertyCursor properties) {
        if (null == key) {
            return false;
        }
        int propertyKey = this.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return false;
        }
        singleEntity.properties(properties, PropertySelection.selection((int)propertyKey));
        return properties.next();
    }

    protected Object getProperty(String key, EntityCursor singleEntity, PropertyCursor properties) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        int propertyKey = this.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        singleEntity.properties(properties, PropertySelection.selection((int)propertyKey));
        if (!properties.next()) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        return properties.propertyValue().asObjectCopy();
    }

    protected Object getProperty(String key, Object defaultValue, EntityCursor singleEntity, PropertyCursor properties) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        int propertyKey = this.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return defaultValue;
        }
        singleEntity.properties(properties, PropertySelection.selection((int)propertyKey));
        return properties.next() ? properties.propertyValue().asObjectCopy() : defaultValue;
    }

    protected Iterable<String> getPropertyKeys(EntityCursor singleEntity, PropertyCursor properties) {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            TokenRead token = this.tokenRead();
            singleEntity.properties(properties, PropertySelection.ALL_PROPERTIES);
            while (properties.next()) {
                keys.add(token.propertyKeyName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    protected Map<String, Object> getProperties(EntityCursor singleEntity, PropertyCursor properties, String ... keys) {
        Objects.requireNonNull(keys, "Properties keys should be not null array.");
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        int[] propertyIds = this.propertyIds(this.tokenRead(), keys);
        HashMap<String, Object> result = new HashMap<String, Object>(propertyIds.length);
        singleEntity.properties(properties, PropertySelection.selection((int[])propertyIds));
        while (properties.next()) {
            result.put(keys[ArrayUtils.indexOf((int[])propertyIds, (int)properties.propertyKey())], properties.propertyValue().asObjectCopy());
        }
        return result;
    }

    public Map<String, Object> getAllProperties(EntityCursor singleEntity, PropertyCursor properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            TokenRead token = this.tokenRead();
            singleEntity.properties(properties, PropertySelection.ALL_PROPERTIES);
            while (properties.next()) {
                result.put(token.propertyKeyName(properties.propertyKey()), properties.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return result;
    }

    private int[] propertyIds(TokenRead tokenRead, String ... keys) {
        int[] propertyIds = new int[keys.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            String key = keys[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i));
            }
            propertyIds[i] = tokenRead.propertyKey(key);
        }
        return propertyIds;
    }

    protected abstract TokenRead tokenRead();
}

