/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public interface DatabaseReferenceRepository {
    public Optional<DatabaseReference> getByAlias(NormalizedCatalogEntry var1);

    public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName var1);

    public Optional<DatabaseReference> getByUuid(UUID var1);

    default public Optional<DatabaseReferenceImpl.Internal> getInternalByAlias(NormalizedDatabaseName databaseAlias) {
        return this.getByAlias(databaseAlias).filter(DatabaseReferenceImpl.Internal.class::isInstance).map(DatabaseReferenceImpl.Internal.class::cast);
    }

    default public Optional<DatabaseReferenceImpl.External> getExternalByAlias(NormalizedDatabaseName databaseAlias) {
        return this.getByAlias(databaseAlias).filter(DatabaseReferenceImpl.External.class::isInstance).map(DatabaseReferenceImpl.External.class::cast);
    }

    default public Optional<DatabaseReference> getByAlias(String databaseName) {
        return this.getByAlias(new NormalizedDatabaseName(databaseName));
    }

    default public Optional<DatabaseReferenceImpl.Internal> getInternalByAlias(String databaseName) {
        return this.getInternalByAlias(new NormalizedDatabaseName(databaseName));
    }

    default public Optional<DatabaseReferenceImpl.External> getExternalByAlias(String databaseName) {
        return this.getExternalByAlias(new NormalizedDatabaseName(databaseName));
    }

    public Set<DatabaseReference> getAllDatabaseReferences();

    public Set<DatabaseReferenceImpl.Internal> getInternalDatabaseReferences();

    public Set<DatabaseReferenceImpl.External> getExternalDatabaseReferences();

    public Set<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferences();

    public static interface Caching
    extends DatabaseReferenceRepository {
        public void invalidateAll();
    }
}

