/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Locale;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;

public final class RelationshipEndpointLabelMissingLabelException
extends ConstraintValidationException {
    private final long relationshipReference;
    private final RelationshipEndpointLabelConstraintDescriptor descriptor;
    private final long nodeReference;

    public RelationshipEndpointLabelMissingLabelException(RelationshipEndpointLabelConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long relationshipReference, long nodeReference, TokenNameLookup tokenNameLookup) {
        super((ConstraintDescriptor)descriptor, phase, "Relationship(" + relationshipReference + ")", tokenNameLookup);
        this.relationshipReference = relationshipReference;
        this.descriptor = descriptor;
        this.nodeReference = nodeReference;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Relationship(%s) with type %s requires it's %s Node(%s) to have label %s", this.relationshipReference, tokenNameLookup.relationshipTypeGetName(this.descriptor.schema().getRelTypeId()), this.descriptor.endpointType().name().toLowerCase(Locale.ROOT), this.nodeReference, tokenNameLookup.labelGetName(this.descriptor.endpointLabelId()));
    }
}

