/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.function.ThrowingLongConsumer;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;

public class RelationshipChangesForNode {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipChangesForNode.class);
    private final DiffStrategy diffStrategy;
    private final MemoryTracker memoryTracker;
    private final MutableIntObjectMap<RelationshipSetsByDirection> byType;

    static RelationshipChangesForNode createRelationshipChangesForNode(DiffStrategy diffStrategy, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new RelationshipChangesForNode(diffStrategy, memoryTracker);
    }

    private RelationshipChangesForNode(DiffStrategy diffStrategy, MemoryTracker memoryTracker) {
        this.diffStrategy = diffStrategy;
        this.memoryTracker = memoryTracker;
        this.byType = HeapTrackingCollections.newIntObjectHashMap((MemoryTracker)memoryTracker);
    }

    public void addRelationship(long relId, int typeId, RelationshipDirection direction) {
        ((RelationshipSetsByDirection)this.byType.getIfAbsentPutWithKey(typeId, (IntToObjectFunction & Serializable)x$0 -> new RelationshipSetsByDirection(x$0))).getOrCreateIds(direction).add(relId);
    }

    public boolean removeRelationship(long relId, int typeId, RelationshipDirection direction) {
        MutableLongSet ids;
        RelationshipSetsByDirection byDirection = (RelationshipSetsByDirection)this.byType.get(typeId);
        if (byDirection != null && (ids = byDirection.getIds(direction)) != null && ids.remove(relId)) {
            if (ids.isEmpty()) {
                byDirection.deleteIds(direction);
                if (byDirection.isEmpty()) {
                    this.byType.remove(typeId);
                }
            }
            return true;
        }
        return false;
    }

    public int augmentDegree(RelationshipDirection direction, int degree, int typeId) {
        return this.diffStrategy.augmentDegree(degree, this.degreeDiff(typeId, direction));
    }

    private int degreeDiff(int type, RelationshipDirection direction) {
        MutableLongSet ids;
        RelationshipSetsByDirection byDirection = (RelationshipSetsByDirection)this.byType.get(type);
        if (byDirection != null && (ids = byDirection.getIds(direction)) != null) {
            return ids.size();
        }
        return 0;
    }

    public void clear() {
        this.byType.clear();
    }

    boolean isEmpty() {
        return this.byType.isEmpty();
    }

    public LongIterator getRelationships() {
        return this.aggregatedIds(RelationshipDirection.INCOMING, RelationshipDirection.OUTGOING, RelationshipDirection.LOOP);
    }

    private static LongIterator nonEmptyConcat(LongIterator ... primitiveIds) {
        return PrimitiveLongCollections.concat((Iterator)Iterators.filter(ids -> ids != ImmutableEmptyLongIterator.INSTANCE, (Iterator)Iterators.iterator((Object[])primitiveIds)));
    }

    public LongIterator getRelationships(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.INCOMING -> this.aggregatedIds(RelationshipDirection.INCOMING, RelationshipDirection.LOOP);
            case Direction.OUTGOING -> this.aggregatedIds(RelationshipDirection.OUTGOING, RelationshipDirection.LOOP);
            case Direction.BOTH -> this.aggregatedIds(RelationshipDirection.INCOMING, RelationshipDirection.OUTGOING, RelationshipDirection.LOOP);
        };
    }

    private LongIterator aggregatedIds(RelationshipDirection ... directions) {
        ArrayList<LongIterator> iterators = new ArrayList<LongIterator>();
        for (RelationshipSetsByDirection byDirection : this.byType) {
            for (RelationshipDirection direction : directions) {
                this.addIdIterator(iterators, byDirection, direction);
            }
        }
        return iterators.isEmpty() ? ImmutableEmptyLongIterator.INSTANCE : RelationshipChangesForNode.nonEmptyConcat((LongIterator[])iterators.toArray(LongIterator[]::new));
    }

    private void addIdIterator(List<LongIterator> iterators, RelationshipSetsByDirection byDirection, RelationshipDirection direction) {
        MutableLongSet ids = byDirection.getIds(direction);
        if (ids != null) {
            iterators.add(RelationshipChangesForNode.primitiveIds((LongSet)ids));
        }
    }

    public LongIterator getRelationships(Direction direction, int type) {
        RelationshipSetsByDirection typeSets = (RelationshipSetsByDirection)this.byType.get(type);
        if (typeSets == null) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
        MutableLongSet loops = typeSets.getIds(RelationshipDirection.LOOP);
        switch (direction) {
            case INCOMING: {
                MutableLongSet incoming = typeSets.getIds(RelationshipDirection.INCOMING);
                return incoming == null && loops == null ? ImmutableEmptyLongIterator.INSTANCE : RelationshipChangesForNode.nonEmptyConcat(RelationshipChangesForNode.primitiveIds((LongSet)incoming), RelationshipChangesForNode.primitiveIds((LongSet)loops));
            }
            case OUTGOING: {
                MutableLongSet outgoing = typeSets.getIds(RelationshipDirection.OUTGOING);
                return outgoing == null && loops == null ? ImmutableEmptyLongIterator.INSTANCE : RelationshipChangesForNode.nonEmptyConcat(RelationshipChangesForNode.primitiveIds((LongSet)outgoing), RelationshipChangesForNode.primitiveIds((LongSet)loops));
            }
            case BOTH: {
                MutableLongSet incoming = typeSets.getIds(RelationshipDirection.INCOMING);
                MutableLongSet outgoing = typeSets.getIds(RelationshipDirection.OUTGOING);
                return RelationshipChangesForNode.nonEmptyConcat(RelationshipChangesForNode.primitiveIds((LongSet)outgoing), RelationshipChangesForNode.primitiveIds((LongSet)incoming), RelationshipChangesForNode.primitiveIds((LongSet)loops));
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    public LongIterator getRelationships(RelationshipDirection direction, int type) {
        RelationshipSetsByDirection typeSets = (RelationshipSetsByDirection)this.byType.get(type);
        if (typeSets == null) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
        MutableLongSet set = typeSets.getIds(direction);
        return set == null ? ImmutableEmptyLongIterator.INSTANCE : RelationshipChangesForNode.primitiveIds((LongSet)set);
    }

    public boolean hasRelationships(int type) {
        RelationshipSetsByDirection byDirection = (RelationshipSetsByDirection)this.byType.get(type);
        if (byDirection != null) {
            return !byDirection.isEmpty();
        }
        return false;
    }

    public IntSet relationshipTypes() {
        return this.byType.keySet();
    }

    private static LongIterator primitiveIds(LongSet relationships) {
        return relationships == null ? ImmutableEmptyLongIterator.INSTANCE : relationships.freeze().longIterator();
    }

    <E extends Exception> void visitIds(ThrowingLongConsumer<E> visitor) throws E {
        for (RelationshipSetsByDirection typeSets : this.byType) {
            if (typeSets.ids == null) continue;
            for (MutableLongSet ids : typeSets.ids) {
                if (ids == null) continue;
                MutableLongIterator idIterator = ids.longIterator();
                while (idIterator.hasNext()) {
                    visitor.accept(idIterator.next());
                }
            }
        }
    }

    void visitIdsSplit(RelationshipModifications.InterruptibleTypeIdsVisitor idsByType, RelationshipModifications.IdDataDecorator idDataDecorator) {
        RelationshipSetsByDirection typeSets;
        Iterator iterator = this.byType.iterator();
        while (iterator.hasNext() && !idsByType.test((Object)new IdsByType(typeSets = (RelationshipSetsByDirection)iterator.next(), idDataDecorator))) {
        }
    }

    int totalCount() {
        int count = 0;
        for (RelationshipSetsByDirection byDirection : this.byType) {
            count += this.count(byDirection, RelationshipDirection.OUTGOING);
            count += this.count(byDirection, RelationshipDirection.INCOMING);
            count += this.count(byDirection, RelationshipDirection.LOOP);
        }
        return count;
    }

    private int count(RelationshipSetsByDirection byDirection, RelationshipDirection direction) {
        MutableLongSet ids = byDirection.getIds(direction);
        return ids != null ? ids.size() : 0;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DiffStrategy {
        REMOVE{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree - diff;
            }
        }
        ,
        ADD{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree + diff;
            }
        }
        ,
        IGNORE{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree;
            }
        };


        abstract int augmentDegree(int var1, int var2);
    }

    private class RelationshipSetsByDirection {
        private final int type;
        private MutableLongSet[] ids;

        RelationshipSetsByDirection(int type) {
            this.type = type;
        }

        MutableLongSet getIds(RelationshipDirection direction) {
            return this.ids == null ? null : this.ids[direction.ordinal()];
        }

        MutableLongSet getOrCreateIds(RelationshipDirection direction) {
            int index = direction.ordinal();
            if (this.ids == null) {
                this.ids = new MutableLongSet[3];
            }
            if (this.ids[index] == null) {
                this.ids[index] = HeapTrackingCollections.newLongSet((MemoryTracker)RelationshipChangesForNode.this.memoryTracker);
            }
            return this.ids[index];
        }

        void deleteIds(RelationshipDirection direction) {
            assert (this.ids[direction.ordinal()].isEmpty());
            this.ids[direction.ordinal()] = null;
        }

        boolean isEmpty() {
            if (this.ids != null) {
                for (MutableLongSet set : this.ids) {
                    if (set == null || set.isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static final class IdsByType
    implements RelationshipModifications.NodeRelationshipTypeIds {
        private final RelationshipSetsByDirection byDirection;
        private final RelationshipModifications.IdDataDecorator idDataDecorator;

        IdsByType(RelationshipSetsByDirection byDirection, RelationshipModifications.IdDataDecorator idDataDecorator) {
            this.byDirection = byDirection;
            this.idDataDecorator = idDataDecorator;
        }

        public int type() {
            return this.byDirection.type;
        }

        public boolean hasOut() {
            return this.has(RelationshipDirection.OUTGOING);
        }

        public boolean hasIn() {
            return this.has(RelationshipDirection.INCOMING);
        }

        public boolean hasLoop() {
            return this.has(RelationshipDirection.LOOP);
        }

        public RelationshipModifications.RelationshipBatch out() {
            return this.idBatch(RelationshipDirection.OUTGOING);
        }

        public RelationshipModifications.RelationshipBatch in() {
            return this.idBatch(RelationshipDirection.INCOMING);
        }

        public RelationshipModifications.RelationshipBatch loop() {
            return this.idBatch(RelationshipDirection.LOOP);
        }

        private RelationshipModifications.RelationshipBatch idBatch(RelationshipDirection direction) {
            MutableLongSet ids = this.byDirection.getIds(direction);
            return ids != null ? RelationshipModifications.idsAsBatch((LongSet)ids, (RelationshipModifications.IdDataDecorator)this.idDataDecorator) : RelationshipModifications.EMPTY_BATCH;
        }

        private boolean has(RelationshipDirection direction) {
            return this.byDirection.getIds(direction) != null;
        }
    }
}

