/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DatabaseTransactionEventListeners
extends LifecycleAdapter {
    private final GraphDatabaseFacade databaseFacade;
    private final GlobalTransactionEventListeners globalTransactionEventListeners;
    private final String databaseName;
    private final Set<TransactionEventListener<?>> listeners = ConcurrentHashMap.newKeySet();

    public DatabaseTransactionEventListeners(GraphDatabaseFacade databaseFacade, GlobalTransactionEventListeners globalTransactionEventListeners, NamedDatabaseId namedDatabaseId) {
        this.databaseFacade = databaseFacade;
        this.globalTransactionEventListeners = globalTransactionEventListeners;
        this.databaseName = namedDatabaseId.name();
    }

    public void registerTransactionEventListener(TransactionEventListener<?> listener) {
        this.globalTransactionEventListeners.registerTransactionEventListener(this.databaseName, listener);
        this.listeners.add(listener);
    }

    public void unregisterTransactionEventListener(TransactionEventListener<?> listener) {
        this.listeners.remove(listener);
        this.globalTransactionEventListeners.unregisterTransactionEventListener(this.databaseName, listener);
    }

    public void shutdown() {
        for (TransactionEventListener<?> listener : this.listeners) {
            this.globalTransactionEventListeners.unregisterTransactionEventListener(this.databaseName, listener);
        }
    }

    public Collection<TransactionEventListener<?>> getCurrentRegisteredTransactionEventListeners() {
        return this.globalTransactionEventListeners.getDatabaseTransactionEventListeners(this.databaseName);
    }

    public GraphDatabaseFacade getDatabaseFacade() {
        return this.databaseFacade;
    }
}

