/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.UnsafeDirectByteBufferAllocator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ThreadSafePeakMemoryTracker;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.util.concurrent.Runnables;

public class IndexPopulationJob
implements Runnable {
    private static final String INDEX_POPULATION_TAG = "indexPopulationJob";
    private final IndexMonitor monitor;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final ByteBufferFactory bufferFactory;
    private final ThreadSafePeakMemoryTracker memoryAllocationTracker;
    private final MultipleIndexPopulator multiPopulator;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private final String databaseName;
    private final Subject subject;
    private final EntityType populatedEntityType;
    private final List<IndexDescriptor> populatedIndexes = new ArrayList<IndexDescriptor>();
    private volatile StoreScan storeScan;
    private volatile boolean stopped;
    private volatile JobHandle<?> jobHandle;

    public IndexPopulationJob(MultipleIndexPopulator multiPopulator, IndexMonitor monitor, CursorContextFactory contextFactory, MemoryTracker memoryTracker, String databaseName, Subject subject, EntityType populatedEntityType, Config config) {
        this.multiPopulator = multiPopulator;
        this.monitor = monitor;
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
        this.memoryAllocationTracker = new ThreadSafePeakMemoryTracker();
        this.bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, ((Long)config.get(GraphDatabaseInternalSettings.index_populator_block_size)).intValue());
        this.databaseName = databaseName;
        this.subject = subject;
        this.populatedEntityType = populatedEntityType;
    }

    MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator populator, IndexProxyStrategy indexProxyStrategy, FlippableIndexProxy flipper) {
        assert (this.storeScan == null) : "Population have already started, too late to add populators at this point";
        this.populatedIndexes.add(indexProxyStrategy.getIndexDescriptor());
        return this.multiPopulator.addPopulator(populator, indexProxyStrategy, flipper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block20: {
            block18: {
                block19: {
                    block17: {
                        try {
                            cursorContext = this.contextFactory.create("indexPopulationJob");
                            indexDescriptors = this.multiPopulator.indexDescriptors();
                            this.monitor.indexPopulationJobStarting(indexDescriptors);
                            if (!this.multiPopulator.hasPopulators() || this.stopped) {
                                if (cursorContext == null) break block17;
                            }
                            ** GOTO lbl-1000
                            cursorContext.close();
                        }
                        catch (Throwable var4_6) {
                            v0 = new Runnable[4];
                            v0[0] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((MultipleIndexPopulator)this.multiPopulator);
                            v0[1] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((ByteBufferFactory)this.bufferFactory);
                            v0[2] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(), ()V)((IndexPopulationJob)this);
                            v0[3] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, countDown(), ()V)((CountDownLatch)this.doneSignal);
                            Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])v0);
                            throw var4_6;
                        }
                    }
                    v1 = new Runnable[4];
                    v1[0] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((MultipleIndexPopulator)this.multiPopulator);
                    v1[1] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((ByteBufferFactory)this.bufferFactory);
                    v1[2] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(), ()V)((IndexPopulationJob)this);
                    v1[3] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, countDown(), ()V)((CountDownLatch)this.doneSignal);
                    Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])v1);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (this.storeScan != null) {
                            throw new IllegalStateException("Population already started.");
                        }
                        try {
                            this.multiPopulator.create(cursorContext);
                            this.multiPopulator.resetIndexCounts(cursorContext);
                            this.monitor.indexPopulationScanStarting(indexDescriptors);
                            this.indexAllEntities(this.contextFactory);
                            this.monitor.indexPopulationScanComplete(indexDescriptors);
                            if (!this.stopped) break block18;
                            this.multiPopulator.stop(cursorContext);
                            if (cursorContext == null) break block19;
                        }
                        catch (Throwable t) {
                            this.multiPopulator.cancel(t, cursorContext);
                        }
                    }
                    cursorContext.close();
                }
                v2 = new Runnable[4];
                v2[0] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((MultipleIndexPopulator)this.multiPopulator);
                v2[1] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((ByteBufferFactory)this.bufferFactory);
                v2[2] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(), ()V)((IndexPopulationJob)this);
                v2[3] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, countDown(), ()V)((CountDownLatch)this.doneSignal);
                Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])v2);
                return;
            }
            ** try [egrp 6[TRYBLOCK] [4 : 277->298)] { 
lbl-1000:
            // 1 sources

            {
                this.multiPopulator.flipAfterStoreScan(cursorContext);
            }
            break block20;
lbl85:
            // 1 sources

            finally {
                if (cursorContext != null) {
                    cursorContext.close();
                }
            }
        }
        v3 = new Runnable[4];
        v3[0] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((MultipleIndexPopulator)this.multiPopulator);
        v3[1] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((ByteBufferFactory)this.bufferFactory);
        v3[2] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(), ()V)((IndexPopulationJob)this);
        v3[3] = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, countDown(), ()V)((CountDownLatch)this.doneSignal);
        Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])v3);
    }

    private void indexAllEntities(CursorContextFactory contextFactory) {
        this.storeScan = this.multiPopulator.createStoreScan(contextFactory);
        if (!this.stopped) {
            this.storeScan.run(this.multiPopulator);
        }
    }

    PopulationProgress getPopulationProgress(MultipleIndexPopulator.IndexPopulation indexPopulation) {
        if (this.storeScan == null) {
            return PopulationProgress.NONE;
        }
        PopulationProgress storeScanProgress = this.storeScan.getProgress();
        return indexPopulation.progress(storeScanProgress);
    }

    public void stop() {
        this.stopped = true;
        if (this.storeScan != null) {
            this.storeScan.stop();
            if (this.jobHandle != null) {
                this.jobHandle.cancel();
            }
        }
        this.monitor.populationCancelled(this.multiPopulator.indexDescriptors(), this.storeScan != null);
    }

    void stop(MultipleIndexPopulator.IndexPopulation population, CursorContext cursorContext) {
        this.multiPopulator.stop(population, cursorContext);
    }

    void dropPopulation(MultipleIndexPopulator.IndexPopulation population) {
        this.multiPopulator.dropIndexPopulation(population);
    }

    public void update(IndexEntryUpdate<?> update) {
        this.multiPopulator.queueConcurrentUpdate(update);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + String.valueOf(this.multiPopulator) + "]";
    }

    public boolean awaitCompletion(long time, TimeUnit unit) throws InterruptedException {
        if (time == 0L) {
            this.doneSignal.await();
            return false;
        }
        boolean completed = this.doneSignal.await(time, unit);
        return !completed;
    }

    public void setHandle(JobHandle handle) {
        this.jobHandle = handle;
    }

    public ByteBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    public MemoryTracker getMemoryTracker() {
        return this.memoryTracker;
    }

    public JobMonitoringParams getMonitoringParams() {
        return new JobMonitoringParams(this.subject, this.databaseName, this.getMonitoringDescription(), () -> {
            StringBuilder stateDescriptionBuilder = new StringBuilder();
            if (this.populatedIndexes.size() > 1) {
                stateDescriptionBuilder.append("Population of indexes ");
                boolean first = true;
                for (IndexDescriptor index : this.populatedIndexes) {
                    if (first) {
                        first = false;
                    } else {
                        stateDescriptionBuilder.append(",");
                    }
                    stateDescriptionBuilder.append("'").append(index.getName()).append("'");
                }
                stateDescriptionBuilder.append("; ");
            }
            PopulationProgress populationProgress = PopulationProgress.NONE;
            if (this.storeScan != null) {
                populationProgress = this.storeScan.getProgress();
            }
            stateDescriptionBuilder.append("Total progress: ").append(populationProgress.toIndexPopulationProgress().getCompletedPercentage()).append("%");
            return stateDescriptionBuilder.toString();
        });
    }

    private String getMonitoringDescription() {
        if (this.populatedIndexes.isEmpty()) {
            return "Empty index population";
        }
        if (this.populatedIndexes.size() == 1) {
            IndexDescriptor index = this.populatedIndexes.get(0);
            return "Population of index '" + index.getName() + "'";
        }
        return "Population of " + this.populatedIndexes.size() + " '" + String.valueOf(this.populatedEntityType) + "' indexes";
    }

    private /* synthetic */ void lambda$run$0() {
        this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
    }
}

