/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Objects;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.BaseConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.util.Preconditions;

final class NodeLabelExistenceConstraintDefinition
extends BaseConstraintDefinition {
    final Label constrainedLabel;
    final Label requiredLabel;

    NodeLabelExistenceConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, Label constrainedLabel, Label requiredLabel) {
        super(actions, constraint);
        this.constrainedLabel = constrainedLabel;
        this.requiredLabel = requiredLabel;
        Preconditions.checkState((boolean)constraint.isNodeLabelExistenceConstraint(), (String)"constraint expected to be NodeLabelExistenceConstraint");
    }

    @Override
    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        return this.constrainedLabel;
    }

    public ConstraintType getConstraintType() {
        return ConstraintType.NODE_LABEL_EXISTENCE;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof NodeLabelExistenceConstraintDefinition) {
            NodeLabelExistenceConstraintDefinition that = (NodeLabelExistenceConstraintDefinition)o;
            return this.constrainedLabel.name().equals(that.constrainedLabel.name()) && this.requiredLabel.name().equals(that.requiredLabel.name());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.constrainedLabel.name(), this.requiredLabel.name());
    }

    @Override
    public String toString() {
        String constrainedLabelName = NameUtil.escapeName((String)this.constrainedLabel.name());
        String requiredLabelName = NameUtil.escapeName((String)this.requiredLabel.name());
        return String.format("(:%s => :%s)", constrainedLabelName, requiredLabelName);
    }
}

