/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.internal.kernel.api.security.SecurityContext;

public class OverridableSecurityContext {
    private final SecurityContext originalSecurityContext;
    private SecurityContext currentSecurityContext;

    OverridableSecurityContext(SecurityContext securityContext) {
        this.originalSecurityContext = securityContext;
        this.currentSecurityContext = securityContext;
    }

    SecurityContext originalSecurityContext() {
        return this.originalSecurityContext;
    }

    public SecurityContext currentSecurityContext() {
        return this.currentSecurityContext;
    }

    public Revertable overrideWith(SecurityContext context) {
        SecurityContext contextBeforeOverride = this.currentSecurityContext;
        this.currentSecurityContext = context;
        return () -> {
            this.currentSecurityContext = contextBeforeOverride;
        };
    }

    @FunctionalInterface
    public static interface Revertable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

