/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class RangeIndexReader
extends NativeIndexReader<RangeKey> {
    RangeIndexReader(GBPTree<RangeKey, NullValue> tree, IndexLayout<RangeKey> layout, IndexDescriptor descriptor, IndexUsageTracking usageTracker) {
        super(tree, layout, descriptor, usageTracker);
    }

    @Override
    void validateQuery(IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) {
        RangeIndexReader.validateNoUnsupportedPredicates(predicates);
        RangeIndexReader.validateOrder(constraints.order(), predicates);
        RangeIndexReader.validateCompositeQuery(predicates);
    }

    @Override
    boolean initializeRangeForQuery(RangeKey treeKeyFrom, RangeKey treeKeyTo, PropertyIndexQuery ... predicates) {
        if (RangeIndexReader.isAllQuery(predicates)) {
            RangeIndexReader.initializeAllSlotsForFullRange(treeKeyFrom, treeKeyTo);
            return false;
        }
        block6: for (int i = 0; i < predicates.length; ++i) {
            PropertyIndexQuery predicate = predicates[i];
            switch (predicate.type()) {
                case EXISTS: {
                    treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
                    treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
                    continue block6;
                }
                case EXACT: {
                    PropertyIndexQuery.ExactPredicate exactPredicate = (PropertyIndexQuery.ExactPredicate)predicate;
                    treeKeyFrom.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    treeKeyTo.initFromValue(i, exactPredicate.value(), NativeIndexKey.Inclusion.NEUTRAL);
                    continue block6;
                }
                case RANGE: {
                    PropertyIndexQuery.RangePredicate rangePredicate = (PropertyIndexQuery.RangePredicate)predicate;
                    RangeIndexReader.initFromForRange(i, rangePredicate, treeKeyFrom);
                    RangeIndexReader.initToForRange(i, rangePredicate, treeKeyTo);
                    continue block6;
                }
                case STRING_PREFIX: {
                    PropertyIndexQuery.StringPrefixPredicate prefixPredicate = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                    treeKeyFrom.stateSlot(i).initAsPrefixLow(prefixPredicate.prefix());
                    treeKeyTo.stateSlot(i).initAsPrefixHigh(prefixPredicate.prefix());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("IndexQuery of type " + String.valueOf(predicate.type()) + " is not supported.");
                }
            }
        }
        return false;
    }

    private static boolean isAllQuery(PropertyIndexQuery[] predicates) {
        return predicates.length == 1 && predicates[0].type() == IndexQuery.IndexQueryType.ALL_ENTRIES;
    }

    private static void initializeAllSlotsForFullRange(RangeKey treeKeyFrom, RangeKey treeKeyTo) {
        assert (treeKeyFrom.numberOfStateSlots() == treeKeyTo.numberOfStateSlots());
        for (int i = 0; i < treeKeyFrom.numberOfStateSlots(); ++i) {
            treeKeyFrom.initValueAsLowest(i, ValueGroup.UNKNOWN);
            treeKeyTo.initValueAsHighest(i, ValueGroup.UNKNOWN);
        }
    }

    private static void initFromForRange(int stateSlot, PropertyIndexQuery.RangePredicate<?> rangePredicate, RangeKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyFrom.initFromValue(stateSlot, fromValue, RangeIndexReader.fromInclusion(rangePredicate));
            treeKeyFrom.setCompareId(true);
        }
    }

    private static void initToForRange(int stateSlot, PropertyIndexQuery.RangePredicate<?> rangePredicate, RangeKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(stateSlot, rangePredicate.valueGroup());
        } else {
            treeKeyTo.initFromValue(stateSlot, toValue, RangeIndexReader.toInclusion(rangePredicate));
            treeKeyTo.setCompareId(true);
        }
    }

    private static NativeIndexKey.Inclusion fromInclusion(PropertyIndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.fromInclusive() ? NativeIndexKey.Inclusion.LOW : NativeIndexKey.Inclusion.HIGH;
    }

    private static NativeIndexKey.Inclusion toInclusion(PropertyIndexQuery.RangePredicate<?> rangePredicate) {
        return rangePredicate.toInclusive() ? NativeIndexKey.Inclusion.HIGH : NativeIndexKey.Inclusion.LOW;
    }

    private static void validateNoUnsupportedPredicates(PropertyIndexQuery[] predicates) {
        for (PropertyIndexQuery predicate : predicates) {
            IndexQuery.IndexQueryType type = predicate.type();
            switch (type) {
                case TOKEN_LOOKUP: 
                case BOUNDING_BOX: 
                case STRING_CONTAINS: 
                case STRING_SUFFIX: 
                case FULLTEXT_SEARCH: {
                    throw new IllegalArgumentException(String.format("Tried to query index with illegal query. A %s predicate is not allowed for a %s index. Query was :%s", type, IndexType.RANGE, Arrays.toString(predicates)));
                }
            }
        }
    }

    static void validateOrder(IndexOrder indexOrder, PropertyIndexQuery ... predicates) {
        if (indexOrder == IndexOrder.NONE) {
            return;
        }
        if (!RangeIndexProvider.CAPABILITY.supportsOrdering()) {
            RangeIndexReader.invalidOrder(indexOrder, predicates);
        }
    }

    static void validateCompositeQuery(PropertyIndexQuery ... predicates) {
        block4: for (int i = 1; i < predicates.length; ++i) {
            IndexQuery.IndexQueryType type = predicates[i].type();
            IndexQuery.IndexQueryType prevType = predicates[i - 1].type();
            if (prevType == IndexQuery.IndexQueryType.ALL_ENTRIES) {
                RangeIndexReader.invalidQueryInComposite(prevType, predicates);
            }
            switch (type) {
                case EXISTS: {
                    continue block4;
                }
                case EXACT: 
                case RANGE: 
                case STRING_PREFIX: {
                    if (prevType == IndexQuery.IndexQueryType.EXACT) continue block4;
                    RangeIndexReader.invalidQueryPrecisionInComposite(predicates);
                    continue block4;
                }
                default: {
                    RangeIndexReader.invalidQueryInComposite(type, predicates);
                }
            }
        }
    }

    private static void invalidOrder(IndexOrder indexOrder, PropertyIndexQuery ... predicates) {
        throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. For query %s supports ascending: false, supports descending: false.", indexOrder, Arrays.toString(predicates)));
    }

    private static void invalidQueryInComposite(IndexQuery.IndexQueryType type, PropertyIndexQuery ... predicates) {
        throw new IllegalArgumentException(String.format("Tried to query index with illegal composite query. %s queries are not allowed in composite query. Query was: %s ", type, Arrays.toString(predicates)));
    }

    private static void invalidQueryPrecisionInComposite(PropertyIndexQuery ... predicates) {
        throw new IllegalArgumentException(String.format("Tried to query index with illegal composite query. Composite query must have decreasing precision. Query was: %s ", Arrays.toString(predicates)));
    }
}

