/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class MapCachingDatabaseReferenceRepository
implements DatabaseReferenceRepository.Caching {
    private DatabaseReferenceRepository delegate;
    private volatile Map<NormalizedDatabaseName, DatabaseReference> databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();

    public MapCachingDatabaseReferenceRepository(DatabaseReferenceRepository delegate) {
        this.delegate = delegate;
    }

    public MapCachingDatabaseReferenceRepository() {
        this(null);
    }

    public void setDelegate(DatabaseReferenceRepository delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName databaseAlias) {
        return Optional.ofNullable(this.databaseRefsByName.computeIfAbsent(databaseAlias, this::lookupReferenceOnDelegate));
    }

    private DatabaseReference lookupReferenceOnDelegate(NormalizedDatabaseName databaseName) {
        return this.delegate.getByAlias(databaseName).orElse(null);
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        return this.delegate.getAllDatabaseReferences();
    }

    @Override
    public Set<DatabaseReference.Internal> getInternalDatabaseReferences() {
        return this.delegate.getInternalDatabaseReferences();
    }

    @Override
    public Set<DatabaseReference.External> getExternalDatabaseReferences() {
        return this.delegate.getExternalDatabaseReferences();
    }

    @Override
    public Set<DatabaseReference.Composite> getCompositeDatabaseReferences() {
        return this.delegate.getCompositeDatabaseReferences();
    }

    @Override
    public void invalidateAll() {
        this.databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();
    }
}

