/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.Predicate;
import org.neo4j.internal.helpers.collection.LfuCache;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.string.Globbing;
import org.neo4j.token.TokenHolders;

class TokenHoldersIdLookup
implements LoginContext.IdLookup {
    private static final int LOOKUP_CACHE_SIZE = 100;
    private final TokenHolders tokens;
    private final GlobalProcedures globalProcedures;
    private final LfuCache<String, int[]> proceduresLookupCache = new LfuCache("procedures", 100);
    private final LfuCache<String, int[]> functionsLookupCache = new LfuCache("functions", 100);
    private final LfuCache<String, int[]> aggregationFunctionsLookupCache = new LfuCache("aggregationFunctions", 100);

    TokenHoldersIdLookup(TokenHolders tokens, GlobalProcedures globalProcedures) {
        this.tokens = tokens;
        this.globalProcedures = globalProcedures;
    }

    public int getPropertyKeyId(String name) {
        return this.tokens.propertyKeyTokens().getIdByName(name);
    }

    public int getLabelId(String name) {
        return this.tokens.labelTokens().getIdByName(name);
    }

    public int getRelTypeId(String name) {
        return this.tokens.relationshipTypeTokens().getIdByName(name);
    }

    public int[] getProcedureIds(String procedureGlobbing) {
        int[] cachedResult = (int[])this.proceduresLookupCache.get((Object)procedureGlobbing);
        if (cachedResult != null) {
            return cachedResult;
        }
        Predicate matcherPredicate = Globbing.globPredicate((String)procedureGlobbing);
        int[] data = this.globalProcedures.getIdsOfProceduresMatching(p -> matcherPredicate.test(p.signature().name().toString()));
        this.proceduresLookupCache.put((Object)procedureGlobbing, (Object)data);
        return data;
    }

    public int[] getAdminProcedureIds() {
        return this.globalProcedures.getIdsOfProceduresMatching(p -> p.signature().admin());
    }

    public int[] getFunctionIds(String functionGlobbing) {
        int[] cachedResult = (int[])this.functionsLookupCache.get((Object)functionGlobbing);
        if (cachedResult != null) {
            return cachedResult;
        }
        Predicate matcherPredicate = Globbing.globPredicate((String)functionGlobbing);
        int[] data = this.globalProcedures.getIdsOfFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
        this.functionsLookupCache.put((Object)functionGlobbing, (Object)data);
        return data;
    }

    public int[] getAggregatingFunctionIds(String functionGlobbing) {
        int[] cachedResult = (int[])this.aggregationFunctionsLookupCache.get((Object)functionGlobbing);
        if (cachedResult != null) {
            return cachedResult;
        }
        Predicate matcherPredicate = Globbing.globPredicate((String)functionGlobbing);
        int[] data = this.globalProcedures.getIdsOfAggregatingFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
        this.aggregationFunctionsLookupCache.put((Object)functionGlobbing, (Object)data);
        return data;
    }
}

