/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.BaseRelationshipConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipKeyConstraintCreator;

public class RelationshipPropertyUniqueConstraintCreator
extends BaseRelationshipConstraintCreator {
    private final List<String> propertyKeys;

    RelationshipPropertyUniqueConstraintCreator(InternalSchemaActions internalCreator, String name, RelationshipType type, List<String> propertyKeys, IndexType indexType, IndexConfig indexConfig) {
        super(internalCreator, name, type, indexType, indexConfig);
        this.propertyKeys = propertyKeys;
    }

    @Override
    public final RelationshipPropertyUniqueConstraintCreator assertPropertyIsUnique(String propertyKey) {
        return new RelationshipPropertyUniqueConstraintCreator(this.actions, this.name, this.type, IndexCreatorImpl.copyAndAdd(this.propertyKeys, propertyKey), this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator assertPropertyExists(String propertyKey) {
        List<String> keys = List.of(propertyKey);
        if (this.propertyKeys.equals(keys)) {
            return new RelationshipKeyConstraintCreator(this.actions, this.name, this.type, this.propertyKeys, this.indexType, this.indexConfig);
        }
        throw new UnsupportedOperationException("You cannot create a constraint on two different sets of property keys: " + this.propertyKeys + " vs. " + keys + ".");
    }

    @Override
    public ConstraintCreator assertPropertyIsRelationshipKey(String propertyKey) {
        return this.assertPropertyExists(propertyKey);
    }

    @Override
    public ConstraintCreator withName(String name) {
        return new RelationshipPropertyUniqueConstraintCreator(this.actions, name, this.type, this.propertyKeys, this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexType(IndexType indexType) {
        return new RelationshipPropertyUniqueConstraintCreator(this.actions, this.name, this.type, this.propertyKeys, indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new RelationshipPropertyUniqueConstraintCreator(this.actions, this.name, this.type, this.propertyKeys, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }

    @Override
    public final ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        IndexDefinitionImpl definition = new IndexDefinitionImpl(this.actions, null, new RelationshipType[]{this.type}, this.propertyKeys.toArray(new String[0]), true);
        return this.actions.createRelationshipPropertyUniquenessConstraint(definition, this.name, this.indexType, this.indexConfig);
    }
}

