/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.RangeIndexReader;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.memory.MemoryTracker;

class RangeBlockBasedIndexPopulator
extends BlockBasedIndexPopulator<RangeKey> {
    private final TokenNameLookup tokenNameLookup;

    RangeBlockBasedIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<RangeKey> layout, IndexDescriptor descriptor, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, Config config, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, BlockBasedIndexPopulator.Monitor monitor, ImmutableSet<OpenOption> openOptions) {
        super(databaseIndexContext, indexFiles, layout, descriptor, archiveFailedIndex, bufferFactory, config, memoryTracker, monitor, openOptions);
        this.tokenNameLookup = tokenNameLookup;
    }

    @Override
    NativeIndexReader<RangeKey> newReader() {
        return new RangeIndexReader((GBPTree<RangeKey, NullValue>)this.tree, this.layout, this.descriptor);
    }

    @Override
    protected IndexValueValidator instantiateValueValidator() {
        return new GenericIndexKeyValidator(this.tree.keyValueSizeCap(), this.descriptor, (Layout<? extends GenericKey<?>, NullValue>)this.layout, this.tokenNameLookup);
    }
}

