/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.RangeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.kernel.impl.index.schema.RangeLayout;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;

public class RangeIndexProvider
extends NativeIndexProvider<RangeKey, RangeLayout> {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("range", "1.0");
    public static final RangeIndexCapability CAPABILITY = new RangeIndexCapability();
    private final boolean archiveFailedIndex;
    private final Config config;

    public RangeIndexProvider(DatabaseIndexContext databaseIndexContext, IndexDirectoryStructure.Factory directoryStructureFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config) {
        super(databaseIndexContext, DESCRIPTOR, directoryStructureFactory, recoveryCleanupWorkCollector);
        this.archiveFailedIndex = (Boolean)config.get(GraphDatabaseInternalSettings.archive_failed_index);
        this.config = config;
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        return index.getCapability().equals(IndexCapability.NO_CAPABILITY) ? index.withIndexCapability((IndexCapability)CAPABILITY) : index;
    }

    @Override
    RangeLayout layout(IndexDescriptor descriptor) {
        int numberOfSlots = descriptor.schema().getPropertyIds().length;
        return new RangeLayout(numberOfSlots);
    }

    @Override
    protected IndexPopulator newIndexPopulator(IndexFiles indexFiles, RangeLayout layout, IndexDescriptor descriptor, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions) {
        return new RangeBlockBasedIndexPopulator(this.databaseIndexContext, indexFiles, layout, descriptor, this.archiveFailedIndex, bufferFactory, this.config, memoryTracker, tokenNameLookup, (BlockBasedIndexPopulator.Monitor)this.databaseIndexContext.monitors.newMonitor(BlockBasedIndexPopulator.Monitor.class, new String[0]), openOptions);
    }

    @Override
    protected IndexAccessor newIndexAccessor(IndexFiles indexFiles, RangeLayout layout, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions) {
        return new RangeIndexAccessor(this.databaseIndexContext, indexFiles, layout, this.recoveryCleanupWorkCollector, descriptor, tokenNameLookup, openOptions);
    }

    public void validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        if (indexType != IndexType.RANGE) {
            String providerName = this.getProviderDescriptor().name();
            throw new IllegalArgumentException("The '" + providerName + "' index provider does not support " + indexType + " indexes: " + prototype);
        }
        if (!prototype.schema().isLabelSchemaDescriptor() && !prototype.schema().isRelationshipTypeSchemaDescriptor()) {
            throw new IllegalArgumentException("The " + prototype.schema() + " index schema is not a range index schema, which it is required to be for the '" + this.getProviderDescriptor().name() + "' index provider to be able to create an index.");
        }
    }

    public IndexType getIndexType() {
        return IndexType.RANGE;
    }

    private static class RangeIndexCapability
    implements IndexCapability {
        private RangeIndexCapability() {
        }

        public boolean supportsOrdering() {
            return true;
        }

        public boolean supportsReturningValues() {
            return true;
        }

        public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
            Preconditions.requireNonEmpty((Object[])valueCategories);
            Preconditions.requireNoNullElements((Object[])valueCategories);
            return true;
        }

        public boolean areValuesAccepted(Value ... values) {
            Preconditions.requireNonEmpty((Object[])values);
            Preconditions.requireNoNullElements((Object[])values);
            return true;
        }

        public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
            if (!this.areValueCategoriesAccepted(valueCategory)) {
                return false;
            }
            return switch (queryType) {
                case IndexQuery.IndexQueryType.ALL_ENTRIES, IndexQuery.IndexQueryType.EXISTS, IndexQuery.IndexQueryType.EXACT, IndexQuery.IndexQueryType.RANGE, IndexQuery.IndexQueryType.STRING_PREFIX -> true;
                default -> false;
            };
        }

        public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
            return 1.0;
        }

        public boolean supportPartitionedScan(IndexQuery ... queries) {
            Preconditions.requireNonEmpty((Object[])queries);
            Preconditions.requireNoNullElements((Object[])queries);
            block14: for (int i = 0; i < queries.length; ++i) {
                IndexQuery query = queries[i];
                IndexQuery.IndexQueryType type = query.type();
                switch (type) {
                    case ALL_ENTRIES: 
                    case EXISTS: 
                    case EXACT: 
                    case STRING_PREFIX: {
                        break;
                    }
                    case RANGE: {
                        switch (((PropertyIndexQuery)query).valueGroup()) {
                            case GEOMETRY: 
                            case GEOMETRY_ARRAY: {
                                return false;
                            }
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (i <= 0) continue;
                IndexQuery.IndexQueryType prevType = queries[i - 1].type();
                switch (type) {
                    case EXISTS: {
                        switch (prevType) {
                            case EXISTS: 
                            case EXACT: 
                            case RANGE: 
                            case STRING_PREFIX: {
                                continue block14;
                            }
                        }
                        return false;
                    }
                    case EXACT: 
                    case RANGE: 
                    case STRING_PREFIX: {
                        if (prevType == IndexQuery.IndexQueryType.EXACT) continue block14;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

