/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.logging.InternalLog;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreResource;
import org.neo4j.storageengine.api.StoreSnapshot;

public class DefaultStoreSnapshotFactory
implements StoreSnapshot.Factory {
    private final Database database;
    private final FileSystemAbstraction fs;
    private final InternalLog log;

    public DefaultStoreSnapshotFactory(Database database, FileSystemAbstraction fs) {
        this.database = database;
        this.fs = fs;
        this.log = database.getInternalLogProvider().getLog(this.getClass());
    }

    public Optional<StoreSnapshot> createStoreSnapshot() throws IOException {
        if (!this.database.getDatabaseAvailabilityGuard().isAvailable()) {
            this.log.warn("Unable to prepare a store snapshot because database '" + this.database.getNamedDatabaseId().name() + "' is unavailable");
            return Optional.empty();
        }
        Stream<StoreResource> unrecoverableFiles = this.unrecoverableFiles(this.database);
        Path[] recoverableFiles = this.recoverableFiles(this.database);
        CheckPointer checkPointer = (CheckPointer)this.database.getDependencyResolver().resolveDependency(CheckPointer.class);
        Resource checkpointMutex = this.tryCheckpointAndAcquireMutex(checkPointer);
        long lastCommittedTransactionId = checkPointer.lastCheckPointedTransactionId();
        StoreSnapshot snapshot = new StoreSnapshot(unrecoverableFiles, recoverableFiles, lastCommittedTransactionId, this.database.getStoreId(), checkpointMutex);
        return Optional.of(snapshot);
    }

    private Stream<StoreResource> unrecoverableFiles(Database database) throws IOException {
        Path databaseDirectory = database.getDatabaseLayout().databaseDirectory();
        return database.getStoreFileListing().builder().excludeAll().includeAtomicStorageFiles().includeAdditionalProviders().includeSchemaIndexStoreFiles().includeIdFiles().build().stream().map(metadata -> this.toStoreResource(databaseDirectory, (StoreFileMetadata)metadata));
    }

    private Path[] recoverableFiles(Database database) throws IOException {
        try (ResourceIterator<StoreFileMetadata> recoverableFiles = database.getStoreFileListing().builder().excludeAll().includeReplayableStorageFiles().build();){
            Path[] pathArray = (Path[])recoverableFiles.stream().map(StoreFileMetadata::path).toArray(Path[]::new);
            return pathArray;
        }
    }

    private Resource tryCheckpointAndAcquireMutex(CheckPointer checkPointer) throws IOException {
        return this.database.getStoreCopyCheckPointMutex().storeCopy((ThrowingAction<IOException>)((ThrowingAction)() -> checkPointer.tryCheckPoint(new SimpleTriggerInfo("Store copy"))));
    }

    private StoreResource toStoreResource(Path databaseDirectory, StoreFileMetadata storeFileMetadata) {
        Path file = storeFileMetadata.path();
        String relativePath = databaseDirectory.relativize(file).toString();
        return new StoreResource(file, relativePath, storeFileMetadata.recordSize(), this.fs);
    }
}

