/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.database.LogEntryWriterFactory;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.util.VisibleForTesting;

public class TransactionLogWriter {
    private final FlushablePositionAwareChecksumChannel channel;
    private final LogEntryWriterFactory logEntryWriterFactory;

    public TransactionLogWriter(FlushablePositionAwareChecksumChannel channel, LogEntryWriterFactory logEntryWriterFactory) {
        this.channel = channel;
        this.logEntryWriterFactory = logEntryWriterFactory;
    }

    public int append(CommandBatch batch, long transactionId, int previousChecksum) throws IOException {
        LogEntryWriter<FlushablePositionAwareChecksumChannel> writer = this.logEntryWriterFactory.createEntryWriter(this.channel, batch.version());
        if (batch.isFirst()) {
            writer.writeStartEntry(batch.getTimeStarted(), batch.getLatestCommittedTxWhenStarted(), previousChecksum, batch.additionalHeader());
        }
        writer.serialize(batch);
        return batch.isLast() ? writer.writeCommitEntry(transactionId, batch.getTimeCommitted()) : -559063315;
    }

    public LogPosition getCurrentPosition() throws IOException {
        return this.channel.getCurrentPosition();
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker logPositionMarker) throws IOException {
        return this.channel.getCurrentPosition(logPositionMarker);
    }

    @VisibleForTesting
    public FlushablePositionAwareChecksumChannel getChannel() {
        return this.channel;
    }

    @VisibleForTesting
    public LogEntryWriter<FlushablePositionAwareChecksumChannel> getWriter() {
        return this.logEntryWriterFactory.createEntryWriter(this.channel);
    }

    public void append(ByteBuffer byteBuffer) throws IOException {
        this.channel.write(byteBuffer);
    }
}

