/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;

public final class LogHeaderReader {
    private LogHeaderReader() {
    }

    public static LogHeader readLogHeader(FileSystemAbstraction fileSystem, Path file, MemoryTracker memoryTracker) throws IOException {
        return LogHeaderReader.readLogHeader(fileSystem, file, true, memoryTracker);
    }

    public static LogHeader readLogHeader(FileSystemAbstraction fileSystem, Path file, boolean strict, MemoryTracker memoryTracker) throws IOException {
        try (StoreChannel channel = fileSystem.read(file);){
            LogHeader logHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)channel, strict, file, memoryTracker);
            return logHeader;
        }
    }

    public static LogHeader readLogHeader(ReadableByteChannel channel, boolean strict, Path additionalErrorInformation, MemoryTracker memoryTracker) throws IOException {
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(128, ByteOrder.BIG_ENDIAN, memoryTracker);){
            ByteBuffer order = scopedBuffer.getBuffer();
            LogHeader logHeader = LogHeaderReader.readLogHeader(order, channel, strict, additionalErrorInformation);
            return logHeader;
        }
    }

    private static LogHeader readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict, Path fileForAdditionalErrorInformationOrNull) throws IOException {
        if (!LogHeaderReader.safeRead(buffer, channel, 8, strict, fileForAdditionalErrorInformationOrNull)) {
            return null;
        }
        long encodedLogVersions = buffer.getLong();
        if (encodedLogVersions == 0L) {
            return null;
        }
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion(encodedLogVersions);
        long logVersion = LogHeaderReader.decodeLogVersion(encodedLogVersions);
        switch (logFormatVersion) {
            case 6: {
                if (!LogHeaderReader.safeRead(buffer, channel, 8, strict, fileForAdditionalErrorInformationOrNull)) {
                    return null;
                }
                long previousCommittedTx = buffer.getLong();
                return new LogHeader(logFormatVersion, logVersion, previousCommittedTx, null, 16L);
            }
            case 7: {
                if (!LogHeaderReader.safeRead(buffer, channel, 56, strict, fileForAdditionalErrorInformationOrNull)) {
                    return null;
                }
                long previousCommittedTx = buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                return new LogHeader(logFormatVersion, logVersion, previousCommittedTx, null, 64L);
            }
            case 8: {
                if (!LogHeaderReader.safeRead(buffer, channel, 120, strict, fileForAdditionalErrorInformationOrNull)) {
                    return null;
                }
                long previousCommittedTx = buffer.getLong();
                StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)buffer);
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                buffer.getLong();
                return new LogHeader(logFormatVersion, logVersion, previousCommittedTx, storeId, 128L);
            }
        }
        throw new IOException("Unrecognized transaction log format version: " + logFormatVersion);
    }

    private static boolean safeRead(ByteBuffer buffer, ReadableByteChannel channel, int size, boolean strict, Path fileForAdditionalErrorInformationOrNull) throws IOException {
        buffer.clear();
        buffer.limit(size);
        int read = channel.read(buffer);
        if (read != size) {
            if (strict) {
                if (fileForAdditionalErrorInformationOrNull != null) {
                    throw new IncompleteLogHeaderException(fileForAdditionalErrorInformationOrNull, read, size);
                }
                throw new IncompleteLogHeaderException(read, size);
            }
            return false;
        }
        buffer.flip();
        return true;
    }

    static long decodeLogVersion(long encLogVersion) {
        return encLogVersion & 0xFFFFFFFFFFFFFFL;
    }

    static byte decodeLogFormatVersion(long encLogVersion) {
        return (byte)(encLogVersion >> 56 & 0xFFL);
    }
}

