/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.LastClosedPositionProvider;
import org.neo4j.kernel.impl.transaction.log.files.LastCommittedTransactionIdProvider;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionRepositoryProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.StoreId;

public class TransactionLogFilesContext {
    private final AtomicLong rotationThreshold;
    private final AtomicBoolean tryPreallocateTransactionLogs;
    private final CommandReaderFactory commandReaderFactory;
    private final LastCommittedTransactionIdProvider lastCommittedTransactionIdSupplier;
    private final LongSupplier committingTransactionIdSupplier;
    private final LastClosedPositionProvider lastClosedPositionProvider;
    private final LogVersionRepositoryProvider logVersionRepositoryProvider;
    private final FileSystemAbstraction fileSystem;
    private final InternalLogProvider logProvider;
    private final DatabaseTracers databaseTracers;
    private final NativeAccess nativeAccess;
    private final MemoryTracker memoryTracker;
    private final Monitors monitors;
    private final boolean failOnCorruptedLogFiles;
    private final Supplier<StoreId> storeId;
    private final DatabaseHealth databaseHealth;
    private final KernelVersionRepository kernelVersionRepository;
    private final Clock clock;
    private final String databaseName;
    private final Config config;
    private final LogTailMetadata externalTailInfo;
    private final DbmsRuntimeRepository dbmsRuntimeRepository;

    public TransactionLogFilesContext(AtomicLong rotationThreshold, AtomicBoolean tryPreallocateTransactionLogs, CommandReaderFactory commandReaderFactory, LastCommittedTransactionIdProvider lastCommittedTransactionIdSupplier, LongSupplier committingTransactionIdSupplier, LastClosedPositionProvider lastClosedPositionProvider, LogVersionRepositoryProvider logVersionRepositoryProvider, FileSystemAbstraction fileSystem, InternalLogProvider logProvider, DatabaseTracers databaseTracers, Supplier<StoreId> storeId, NativeAccess nativeAccess, MemoryTracker memoryTracker, Monitors monitors, boolean failOnCorruptedLogFiles, DatabaseHealth databaseHealth, KernelVersionRepository kernelVersionRepository, Clock clock, String databaseName, Config config, LogTailMetadata externalTailInfo, DbmsRuntimeRepository dbmsRuntimeRepository) {
        this.rotationThreshold = rotationThreshold;
        this.tryPreallocateTransactionLogs = tryPreallocateTransactionLogs;
        this.commandReaderFactory = commandReaderFactory;
        this.lastCommittedTransactionIdSupplier = lastCommittedTransactionIdSupplier;
        this.committingTransactionIdSupplier = committingTransactionIdSupplier;
        this.lastClosedPositionProvider = lastClosedPositionProvider;
        this.logVersionRepositoryProvider = logVersionRepositoryProvider;
        this.fileSystem = fileSystem;
        this.logProvider = logProvider;
        this.databaseTracers = databaseTracers;
        this.storeId = storeId;
        this.nativeAccess = nativeAccess;
        this.memoryTracker = memoryTracker;
        this.monitors = monitors;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.databaseHealth = databaseHealth;
        this.kernelVersionRepository = kernelVersionRepository;
        this.clock = clock;
        this.databaseName = databaseName;
        this.config = config;
        this.externalTailInfo = externalTailInfo;
        this.dbmsRuntimeRepository = dbmsRuntimeRepository;
    }

    AtomicLong getRotationThreshold() {
        return this.rotationThreshold;
    }

    public CommandReaderFactory getCommandReaderFactory() {
        return this.commandReaderFactory;
    }

    public LogVersionRepositoryProvider getLogVersionRepositoryProvider() {
        return this.logVersionRepositoryProvider;
    }

    public LastCommittedTransactionIdProvider getLastCommittedTransactionIdProvider() {
        return this.lastCommittedTransactionIdSupplier;
    }

    public long committingTransactionId() {
        return this.committingTransactionIdSupplier.getAsLong();
    }

    LastClosedPositionProvider getLastClosedTransactionPositionProvider() {
        return this.lastClosedPositionProvider;
    }

    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    public InternalLogProvider getLogProvider() {
        return this.logProvider;
    }

    AtomicBoolean getTryPreallocateTransactionLogs() {
        return this.tryPreallocateTransactionLogs;
    }

    public NativeAccess getNativeAccess() {
        return this.nativeAccess;
    }

    public DatabaseTracers getDatabaseTracers() {
        return this.databaseTracers;
    }

    public StoreId getStoreId() {
        return this.storeId.get();
    }

    public MemoryTracker getMemoryTracker() {
        return this.memoryTracker;
    }

    public Monitors getMonitors() {
        return this.monitors;
    }

    public boolean isFailOnCorruptedLogFiles() {
        return this.failOnCorruptedLogFiles;
    }

    public DatabaseHealth getDatabaseHealth() {
        return this.databaseHealth;
    }

    public KernelVersionRepository getKernelVersionProvider() {
        return this.kernelVersionRepository;
    }

    public Clock getClock() {
        return this.clock;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Config getConfig() {
        return this.config;
    }

    public LogTailMetadata getExternalTailInfo() {
        return this.externalTailInfo;
    }

    public DbmsRuntimeRepository getDbmsRuntimeRepository() {
        return this.dbmsRuntimeRepository;
    }
}

