/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.time.Instant;
import java.util.function.Predicate;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;

public interface RecoveryPredicate
extends Predicate<CommittedTransactionRepresentation> {
    public static final RecoveryPredicate ALL = new AllTransactionsPredicate();

    public static RecoveryPredicate untilTransactionId(long txId) {
        return new TransactionIdPredicate(txId);
    }

    public static RecoveryPredicate untilInstant(Instant date) {
        return new TransactionDatePredicate(date);
    }

    public String describe();

    public static class TransactionIdPredicate
    implements RecoveryPredicate {
        private final long txId;

        private TransactionIdPredicate(long txId) {
            this.txId = txId;
        }

        @Override
        public boolean test(CommittedTransactionRepresentation transaction) {
            return transaction.commitEntry().getTxId() < this.txId;
        }

        @Override
        public String describe() {
            return "transaction id should be < " + this.txId;
        }
    }

    public static class TransactionDatePredicate
    implements RecoveryPredicate {
        private final Instant instant;

        private TransactionDatePredicate(Instant instant) {
            this.instant = instant;
        }

        @Override
        public boolean test(CommittedTransactionRepresentation transaction) {
            return transaction.startEntry().getTimeWritten() < this.instant.toEpochMilli();
        }

        @Override
        public String describe() {
            return "transaction date should be before " + Format.date((Instant)this.instant);
        }
    }

    public static class AllTransactionsPredicate
    implements RecoveryPredicate {
        private AllTransactionsPredicate() {
        }

        @Override
        public String describe() {
            return "all transactions predicate.";
        }

        @Override
        public boolean test(CommittedTransactionRepresentation committedTransactionRepresentation) {
            return true;
        }
    }
}

