/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformation;

public class RecoveryStartInformationProvider
implements ThrowingSupplier<RecoveryStartInformation, IOException> {
    public static final Monitor NO_MONITOR = new Monitor(){};
    private final LogFiles logFiles;
    private final Monitor monitor;

    public RecoveryStartInformationProvider(LogFiles logFiles, Monitor monitor) {
        this.logFiles = logFiles;
        this.monitor = monitor;
    }

    public RecoveryStartInformation get() {
        LogTailInformation logTailInformation = (LogTailInformation)this.logFiles.getTailMetadata();
        CheckpointInfo lastCheckPoint = logTailInformation.lastCheckPoint;
        long txIdAfterLastCheckPoint = logTailInformation.firstTxIdAfterLastCheckPoint;
        if (!logTailInformation.isRecoveryRequired()) {
            this.monitor.noCommitsAfterLastCheckPoint(lastCheckPoint != null ? lastCheckPoint.transactionLogPosition() : null);
            return RecoveryStartInformation.NO_RECOVERY_REQUIRED;
        }
        if (logTailInformation.logsMissing()) {
            return RecoveryStartInformation.MISSING_LOGS;
        }
        if (logTailInformation.commitsAfterLastCheckpoint()) {
            if (lastCheckPoint == null) {
                long lowestLogVersion = this.logFiles.getLogFile().getLowestLogVersion();
                if (lowestLogVersion != 0L) {
                    throw new UnderlyingStorageException("No check point found in any log file from version " + lowestLogVersion + " to " + logTailInformation.currentLogVersion);
                }
                this.monitor.noCheckPointFound();
                LogPosition position = this.tryExtractHeaderSize();
                return RecoveryStartInformationProvider.createRecoveryInformation(position, new LogPosition(0L, 128L), txIdAfterLastCheckPoint);
            }
            LogPosition transactionLogPosition = lastCheckPoint.transactionLogPosition();
            this.monitor.commitsAfterLastCheckPoint(transactionLogPosition, txIdAfterLastCheckPoint);
            return RecoveryStartInformationProvider.createRecoveryInformation(transactionLogPosition, lastCheckPoint.checkpointEntryPosition(), txIdAfterLastCheckPoint);
        }
        throw new UnderlyingStorageException("Fail to determine recovery information Log tail info: " + logTailInformation);
    }

    private LogPosition tryExtractHeaderSize() {
        try {
            return this.logFiles.getLogFile().extractHeader(0L).getStartPosition();
        }
        catch (IOException e) {
            this.monitor.failToExtractInitialFileHeader(e);
            return new LogPosition(0L, 128L);
        }
    }

    private static RecoveryStartInformation createRecoveryInformation(LogPosition transactionLogPosition, LogPosition checkpointLogPosition, long firstTxId) {
        return new RecoveryStartInformation(transactionLogPosition, checkpointLogPosition, firstTxId);
    }

    public static interface Monitor {
        default public void noCommitsAfterLastCheckPoint(LogPosition logPosition) {
        }

        default public void commitsAfterLastCheckPoint(LogPosition logPosition, long firstTxIdAfterLastCheckPoint) {
        }

        default public void noCheckPointFound() {
        }

        default public void failToExtractInitialFileHeader(Exception e) {
        }
    }
}

