/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.ProgressReporter;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryPredicateException;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.time.Stopwatch;

public class TransactionLogsRecovery
extends LifecycleAdapter {
    private static final String REVERSE_RECOVERY_TAG = "restoreDatabase";
    private static final String RECOVERY_TAG = "recoverDatabase";
    private static final String RECOVERY_COMPLETED_TAG = "databaseRecoveryCompleted";
    private final RecoveryService recoveryService;
    private final RecoveryMonitor monitor;
    private final CorruptedLogsTruncator logsTruncator;
    private final Lifecycle schemaLife;
    private final ProgressReporter progressReporter;
    private final boolean failOnCorruptedLogFiles;
    private final RecoveryStartupChecker recoveryStartupChecker;
    private final CursorContextFactory contextFactory;
    private final RecoveryPredicate recoveryPredicate;
    private int numberOfRecoveredTransactions;

    public TransactionLogsRecovery(RecoveryService recoveryService, CorruptedLogsTruncator logsTruncator, Lifecycle schemaLife, RecoveryMonitor monitor, ProgressReporter progressReporter, boolean failOnCorruptedLogFiles, RecoveryStartupChecker recoveryStartupChecker, RecoveryPredicate recoveryPredicate, CursorContextFactory contextFactory) {
        this.recoveryService = recoveryService;
        this.monitor = monitor;
        this.logsTruncator = logsTruncator;
        this.schemaLife = schemaLife;
        this.progressReporter = progressReporter;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.recoveryStartupChecker = recoveryStartupChecker;
        this.contextFactory = contextFactory;
        this.recoveryPredicate = recoveryPredicate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws Exception {
        RecoveryStartInformation recoveryStartInformation = this.recoveryService.getRecoveryStartInformation();
        if (!recoveryStartInformation.isRecoveryRequired()) {
            this.schemaLife.init();
            return;
        }
        Stopwatch recoveryStartTime = Stopwatch.start();
        LogPosition recoveryStartPosition = recoveryStartInformation.getTransactionLogPosition();
        this.monitor.recoveryRequired(recoveryStartPosition);
        LogPosition recoveryToPosition = recoveryStartPosition;
        LogPosition lastTransactionPosition = recoveryStartPosition;
        CommittedTransactionRepresentation lastTransaction = null;
        CommittedTransactionRepresentation lastReversedTransaction = null;
        if (!recoveryStartInformation.isMissingLogs()) {
            try {
                long lowestRecoveredTxId = 1L;
                try (TransactionCursor transactionsToRecover = this.recoveryService.getTransactionsInReverseOrder(recoveryStartPosition);
                     RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.REVERSE_RECOVERY, this.contextFactory, REVERSE_RECOVERY_TAG);){
                    while (transactionsToRecover.next()) {
                        this.recoveryStartupChecker.checkIfCanceled();
                        CommittedTransactionRepresentation transaction = (CommittedTransactionRepresentation)transactionsToRecover.get();
                        if (lastReversedTransaction == null) {
                            lastReversedTransaction = transaction;
                            this.initProgressReporter(recoveryStartInformation, lastReversedTransaction);
                        }
                        recoveryVisitor.visit(transaction);
                        lowestRecoveredTxId = transaction.commitEntry().getTxId();
                        this.reportProgress();
                    }
                }
                this.monitor.reverseStoreRecoveryCompleted(lowestRecoveredTxId);
                this.schemaLife.init();
                boolean fullRecovery = true;
                try (TransactionCursor transactionsToRecover = this.recoveryService.getTransactions(recoveryStartPosition);
                     RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.RECOVERY, this.contextFactory, RECOVERY_TAG);){
                    while (fullRecovery && transactionsToRecover.next()) {
                        CommittedTransactionRepresentation nextTransaction = (CommittedTransactionRepresentation)transactionsToRecover.get();
                        if (!this.recoveryPredicate.test(nextTransaction)) {
                            this.monitor.partialRecovery(this.recoveryPredicate, lastTransaction);
                            fullRecovery = false;
                            if (lastTransaction != null) continue;
                            long beforeCheckpointTransaction = recoveryStartInformation.getFirstTxIdAfterLastCheckPoint() - 1L;
                            if (beforeCheckpointTransaction < 1L) {
                                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint is not valid. Transaction id before checkpoint: %d, criteria %s.", beforeCheckpointTransaction, this.recoveryPredicate.describe()));
                            }
                            try {
                                TransactionCursor beforeCheckpointCursor = this.recoveryService.getTransactions(beforeCheckpointTransaction);
                                try {
                                    if (beforeCheckpointCursor.next()) {
                                        CommittedTransactionRepresentation candidate = (CommittedTransactionRepresentation)beforeCheckpointCursor.get();
                                        if (!this.recoveryPredicate.test(candidate)) {
                                            throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. Transaction after and before checkpoint does not satisfy provided recovery criteria. Observed transaction id: %d, recovery criteria: %s.", candidate.commitEntry().getTxId(), this.recoveryPredicate.describe()));
                                        }
                                        lastTransaction = candidate;
                                        lastTransactionPosition = beforeCheckpointCursor.position();
                                        continue;
                                    }
                                    throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint not found. Recovery criteria: %s.", this.recoveryPredicate.describe()));
                                }
                                finally {
                                    if (beforeCheckpointCursor == null) continue;
                                    beforeCheckpointCursor.close();
                                    continue;
                                }
                            }
                            catch (RecoveryPredicateException re) {
                                throw re;
                            }
                            catch (Exception e) {
                                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and fail to read transaction before checkpoint. Recovery criteria: %s.", this.recoveryPredicate.describe()), e);
                            }
                        }
                        this.recoveryStartupChecker.checkIfCanceled();
                        long txId = nextTransaction.commitEntry().getTxId();
                        recoveryVisitor.visit(nextTransaction);
                        lastTransaction = nextTransaction;
                        this.monitor.transactionRecovered(txId);
                        ++this.numberOfRecoveredTransactions;
                        recoveryToPosition = lastTransactionPosition = transactionsToRecover.position();
                        this.reportProgress();
                    }
                    recoveryToPosition = fullRecovery ? transactionsToRecover.position() : lastTransactionPosition;
                }
            }
            catch (Error | ClosedByInterruptException | DatabaseStartAbortedException | RecoveryPredicateException e) {
                throw e;
            }
            catch (Throwable t) {
                if (this.failOnCorruptedLogFiles) {
                    Recovery.throwUnableToCleanRecover(t);
                }
                if (lastTransaction != null) {
                    LogEntryCommit commitEntry = lastTransaction.commitEntry();
                    this.monitor.failToRecoverTransactionsAfterCommit(t, commitEntry, recoveryToPosition);
                }
                this.monitor.failToRecoverTransactionsAfterPosition(t, recoveryStartPosition);
            }
            this.progressReporter.completed();
            this.logsTruncator.truncate(recoveryToPosition);
        }
        try (CursorContext cursorContext = this.contextFactory.create(RECOVERY_COMPLETED_TAG);){
            boolean missingLogs = recoveryStartInformation.isMissingLogs();
            this.recoveryService.transactionsRecovered(lastTransaction, lastTransactionPosition, recoveryToPosition, recoveryStartInformation.getCheckpointPosition(), missingLogs, cursorContext);
        }
        this.monitor.recoveryCompleted(this.numberOfRecoveredTransactions, recoveryStartTime.elapsed(TimeUnit.MILLISECONDS));
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, CommittedTransactionRepresentation lastReversedTransaction) {
        long numberOfTransactionToRecover = TransactionLogsRecovery.getNumberOfTransactionToRecover(recoveryStartInformation, lastReversedTransaction);
        this.progressReporter.start(numberOfTransactionToRecover * 2L);
    }

    private void reportProgress() {
        this.progressReporter.progress(1L);
    }

    private static long getNumberOfTransactionToRecover(RecoveryStartInformation recoveryStartInformation, CommittedTransactionRepresentation lastReversedTransaction) {
        return lastReversedTransaction.commitEntry().getTxId() - recoveryStartInformation.getFirstTxIdAfterLastCheckPoint() + 1L;
    }

    public void start() throws Exception {
        this.schemaLife.start();
    }

    public void stop() throws Exception {
        this.schemaLife.stop();
    }

    public void shutdown() throws Exception {
        this.schemaLife.shutdown();
    }
}

