/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.dbms.database.TicketMachine;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.monitoring.PageFileCounters;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.FileMappedListener;
import org.neo4j.io.pagecache.tracing.version.FileTruncateEvent;

public class DatabasePageCache
implements PageCache {
    private final PageCache globalPageCache;
    private final Map<Path, DatabasePagedFile> uniqueDatabasePagedFiles = new ConcurrentHashMap<Path, DatabasePagedFile>();
    private final IOController ioController;
    private final List<FileMappedListener> mappedListeners = new CopyOnWriteArrayList<FileMappedListener>();
    private boolean closed;
    private final TicketMachine ticketMachine = new TicketMachine();
    private final VersionStorage versionStorage;

    public DatabasePageCache(PageCache globalPageCache, IOController ioController, VersionStorage versionStorage) {
        this.globalPageCache = Objects.requireNonNull(globalPageCache);
        this.ioController = Objects.requireNonNull(ioController);
        this.versionStorage = Objects.requireNonNull(versionStorage);
    }

    public synchronized PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions, IOController ignoredController, VersionStorage ignoredVersionStorage) throws IOException {
        PagedFile pagedFile = this.globalPageCache.map(path, pageSize, databaseName, openOptions, this.ioController, this.versionStorage);
        DatabasePagedFile newMapping = new DatabasePagedFile(pagedFile, this.ticketMachine.newTicket());
        DatabasePagedFile existingMapping = this.uniqueDatabasePagedFiles.putIfAbsent(path, newMapping);
        if (existingMapping == null) {
            DatabasePageCache.invokeFileMapListeners(this.mappedListeners, newMapping);
            return newMapping;
        }
        existingMapping.refCount.incrementAndGet();
        return existingMapping;
    }

    public Optional<PagedFile> getExistingMapping(Path path) {
        Path canonicalFile = path.normalize();
        return this.uniqueDatabasePagedFiles.values().stream().filter(pagedFile -> pagedFile.path().equals(canonicalFile)).map(pf -> pf).findFirst();
    }

    public List<PagedFile> listExistingMappings() {
        return new ArrayList<PagedFile>(this.uniqueDatabasePagedFiles.values());
    }

    public void flushAndForce(DatabaseFlushEvent flushEvent) throws IOException {
        this.flushAndForce(flushEvent, TicketMachine.Barrier.NO_BARRIER);
    }

    private void flushAndForce(DatabaseFlushEvent flushEvent, TicketMachine.Barrier barrier) throws IOException {
        for (DatabasePagedFile pagedFile : this.uniqueDatabasePagedFiles.values()) {
            if (!barrier.canPass(pagedFile.flushTicket())) continue;
            FileFlushEvent fileFlushEvent = flushEvent.beginFileFlush();
            try {
                pagedFile.flushAndForce(fileFlushEvent);
            }
            finally {
                if (fileFlushEvent == null) continue;
                fileFlushEvent.close();
            }
        }
    }

    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException("Database page cache was already closed");
        }
        for (DatabasePagedFile pagedFile : this.uniqueDatabasePagedFiles.values()) {
            while (pagedFile.refCount.get() > 0) {
                pagedFile.close();
            }
        }
        this.uniqueDatabasePagedFiles.clear();
        this.closed = true;
    }

    public int pageSize() {
        return this.globalPageCache.pageSize();
    }

    public int pageReservedBytes(ImmutableSet<OpenOption> openOptions) {
        return this.globalPageCache.pageReservedBytes(openOptions);
    }

    public long maxCachedPages() {
        return this.globalPageCache.maxCachedPages();
    }

    public IOBufferFactory getBufferFactory() {
        return this.globalPageCache.getBufferFactory();
    }

    private static void invokeFileMapListeners(List<FileMappedListener> listeners, DatabasePagedFile databasePageFile) {
        for (FileMappedListener mappedListener : listeners) {
            mappedListener.fileMapped((PagedFile)databasePageFile);
        }
    }

    private static void invokeFileUnmapListeners(List<FileMappedListener> listeners, DatabasePagedFile databasePageFile) {
        for (FileMappedListener mappedListener : listeners) {
            mappedListener.fileUnmapped((PagedFile)databasePageFile);
        }
    }

    public void registerFileMappedListener(FileMappedListener mappedListener) {
        this.mappedListeners.add(mappedListener);
    }

    public void unregisterFileMappedListener(FileMappedListener mappedListener) {
        this.mappedListeners.remove(mappedListener);
    }

    public FlushGuard flushGuard(DatabaseFlushEvent flushEvent) {
        TicketMachine.Barrier barrier = this.ticketMachine.nextBarrier();
        return () -> this.flushAndForce(flushEvent, barrier);
    }

    private synchronized void unmap(DatabasePagedFile databasePagedFile) {
        if (databasePagedFile.refCount.decrementAndGet() == 0) {
            DatabasePageCache.invokeFileUnmapListeners(this.mappedListeners, databasePagedFile);
            this.uniqueDatabasePagedFiles.remove(databasePagedFile.path());
        }
    }

    private class DatabasePagedFile
    implements PagedFile {
        private final PagedFile delegate;
        private final TicketMachine.Ticket flushTicket;
        private final AtomicInteger refCount = new AtomicInteger(1);

        DatabasePagedFile(PagedFile delegate, TicketMachine.Ticket flushTicket) {
            this.delegate = delegate;
            this.flushTicket = flushTicket;
        }

        public PageCursor io(long pageId, int pf_flags, CursorContext context) throws IOException {
            return this.delegate.io(pageId, pf_flags, context);
        }

        public int pageSize() {
            return this.delegate.pageSize();
        }

        public int payloadSize() {
            return this.delegate.payloadSize();
        }

        public int pageReservedBytes() {
            return this.delegate.pageReservedBytes();
        }

        public long fileSize() throws IOException {
            return this.delegate.fileSize();
        }

        public Path path() {
            return this.delegate.path();
        }

        public void flushAndForce(FileFlushEvent flushEvent) throws IOException {
            this.delegate.flushAndForce(flushEvent);
            this.flushTicket.use();
        }

        public long getLastPageId() throws IOException {
            return this.delegate.getLastPageId();
        }

        public void increaseLastPageIdTo(long newLastPageId) {
            this.delegate.increaseLastPageIdTo(newLastPageId);
        }

        public void close() {
            DatabasePageCache.this.unmap(this);
            this.delegate.close();
        }

        public void setDeleteOnClose(boolean deleteOnClose) {
            this.delegate.setDeleteOnClose(deleteOnClose);
        }

        public boolean isDeleteOnClose() {
            return this.delegate.isDeleteOnClose();
        }

        public String getDatabaseName() {
            return this.delegate.getDatabaseName();
        }

        public PageFileCounters pageFileCounters() {
            return this.delegate.pageFileCounters();
        }

        public boolean isMultiVersioned() {
            return this.delegate.isMultiVersioned();
        }

        public void truncate(long pagesToKeep, FileTruncateEvent fileTruncateEvent) throws IOException {
            this.delegate.truncate(pagesToKeep, fileTruncateEvent);
        }

        public int touch(long pageId, int count, CursorContext cursorContext) throws IOException {
            return this.delegate.touch(pageId, count, cursorContext);
        }

        public boolean preAllocateSupported() {
            return this.delegate.preAllocateSupported();
        }

        public void preAllocate(long newFileSizeInPages) throws IOException {
            this.delegate.preAllocate(newFileSizeInPages);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabasePagedFile that = (DatabasePagedFile)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        TicketMachine.Ticket flushTicket() {
            return this.flushTicket;
        }
    }

    @FunctionalInterface
    public static interface FlushGuard {
        public void flushUnflushed() throws IOException;
    }
}

