/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.util.FeatureToggles;

public class ParallelAccessCheck {
    public static final boolean CHECK_PARALLEL_ACCESS = FeatureToggles.flag(ParallelAccessCheck.class, (String)"CHECK_PARALLEL_ACCESS", (boolean)false);

    public static boolean shouldPerformCheck() {
        return CHECK_PARALLEL_ACCESS;
    }

    public static void checkNotCypherWorkerThread() {
        if (Thread.currentThread().getThreadGroup().getName().equals(Group.CYPHER_WORKER.groupName())) {
            throw new IllegalStateException("A resource that does not support parallel access is being accessed by a Cypher worker thread");
        }
    }

    public static Locks.Client maybeWrapLockClient(final Locks.Client wrappedLockClient) {
        return new Locks.Client(){

            public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                return wrappedLockClient.tryExclusiveLock(resourceType, resourceId);
            }

            public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.acquireExclusive(tracer, resourceType, resourceIds);
            }

            public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.releaseExclusive(resourceType, resourceIds);
            }

            public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.acquireShared(tracer, resourceType, resourceIds);
            }

            public void releaseShared(ResourceType resourceType, long ... resourceIds) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.releaseShared(resourceType, resourceIds);
            }

            public Stream<ActiveLock> activeLocks() {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                return wrappedLockClient.activeLocks();
            }

            public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                return wrappedLockClient.holdsLock(id, resource, lockType);
            }

            public void initialize(LeaseClient leaseClient, long transactionId, MemoryTracker memoryTracker, Config config) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.initialize(leaseClient, transactionId, memoryTracker, config);
            }

            public boolean trySharedLock(ResourceType resourceType, long resourceId) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                return wrappedLockClient.trySharedLock(resourceType, resourceId);
            }

            public void prepareForCommit() {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.prepareForCommit();
            }

            public void stop() {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.stop();
            }

            public void close() {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                wrappedLockClient.close();
            }

            public long getTransactionId() {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                return wrappedLockClient.getTransactionId();
            }

            public long activeLockCount() {
                ParallelAccessCheck.checkNotCypherWorkerThread();
                return wrappedLockClient.activeLockCount();
            }
        };
    }
}

