/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintCreator;

public class NodePropertyUniqueConstraintCreator
extends BaseNodeConstraintCreator {
    private final List<String> propertyKeys;

    NodePropertyUniqueConstraintCreator(InternalSchemaActions internalCreator, String name, Label label, List<String> propertyKeys, IndexType indexType, IndexConfig indexConfig) {
        super(internalCreator, name, label, indexType, indexConfig);
        this.propertyKeys = propertyKeys;
    }

    @Override
    public final NodePropertyUniqueConstraintCreator assertPropertyIsUnique(String propertyKey) {
        return new NodePropertyUniqueConstraintCreator(this.actions, this.name, this.label, IndexCreatorImpl.copyAndAdd(this.propertyKeys, propertyKey), this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator assertPropertyExists(String propertyKey) {
        List<String> keys = List.of(propertyKey);
        if (this.propertyKeys.equals(keys)) {
            return new NodeKeyConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, this.indexType, this.indexConfig);
        }
        throw new UnsupportedOperationException("You cannot create a constraint on two different sets of property keys: " + this.propertyKeys + " vs. " + keys + ".");
    }

    @Override
    public ConstraintCreator assertPropertyIsNodeKey(String propertyKey) {
        return this.assertPropertyExists(propertyKey);
    }

    @Override
    public ConstraintCreator withName(String name) {
        return new NodePropertyUniqueConstraintCreator(this.actions, name, this.label, this.propertyKeys, this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexType(IndexType indexType) {
        return new NodePropertyUniqueConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new NodePropertyUniqueConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }

    @Override
    public final ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        IndexDefinitionImpl definition = new IndexDefinitionImpl(this.actions, null, new Label[]{this.label}, this.propertyKeys.toArray(new String[0]), true);
        return this.actions.createNodePropertyUniquenessConstraint(definition, this.name, this.indexType, this.indexConfig);
    }
}

