/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.impl.api.chunk.ChunkMetadata;
import org.neo4j.kernel.impl.api.chunk.CommandChunk;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.v56.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.entry.v56.LogEntryChunkStart;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public record CommittedChunkRepresentation(LogEntryChunkStart chunkStart, CommandBatch commandBatch, LogEntryChunkEnd chunkEnd) implements CommittedCommandBatch
{
    public static CommittedChunkRepresentation createChunkRepresentation(LogEntry start, List<StorageCommand> commands, LogEntry end) {
        LogEntryChunkStart logEntryChunkStart = CommittedChunkRepresentation.createChunkStart(start);
        LogEntryChunkEnd logEntryChunkEnd = CommittedChunkRepresentation.createChunkEnd(end, logEntryChunkStart);
        ChunkMetadata chunkMetadata = new ChunkMetadata(start instanceof LogEntryStart, end instanceof LogEntryCommit, false, logEntryChunkStart.getPreviousBatchLogPosition(), logEntryChunkStart.getChunkId(), -1L, logEntryChunkStart.getTimeWritten(), -1L, logEntryChunkStart.getTimeWritten(), -1, logEntryChunkStart.kernelVersion(), Subject.AUTH_DISABLED);
        return new CommittedChunkRepresentation(logEntryChunkStart, new CommandChunk(commands, chunkMetadata), logEntryChunkEnd);
    }

    @Override
    public int serialize(LogEntryWriter<? extends WritableChecksumChannel> writer) throws IOException {
        byte version = this.chunkStart.kernelVersion().version();
        writer.writeChunkStartEntry(version, this.chunkStart.getTimeWritten(), this.chunkStart.getChunkId(), this.chunkStart.getPreviousBatchLogPosition());
        writer.serialize(this.commandBatch);
        return writer.writeChunkEndEntry(version, this.chunkEnd.getTransactionId(), this.chunkEnd.getChunkId());
    }

    @Override
    public int checksum() {
        return this.chunkEnd.getChecksum();
    }

    @Override
    public long timeWritten() {
        return this.chunkStart.getTimeWritten();
    }

    @Override
    public long txId() {
        return this.chunkEnd.getTransactionId();
    }

    @Override
    public boolean isRollback() {
        return false;
    }

    @Override
    public LogPosition previousBatchLogPosition() {
        return this.chunkStart.getPreviousBatchLogPosition();
    }

    private static LogEntryChunkStart createChunkStart(LogEntry start) {
        if (start instanceof LogEntryChunkStart) {
            LogEntryChunkStart chunkStart = (LogEntryChunkStart)start;
            return chunkStart;
        }
        if (start instanceof LogEntryStart) {
            LogEntryStart entryStart = (LogEntryStart)start;
            return new LogEntryChunkStart(entryStart.kernelVersion(), entryStart.getTimeWritten(), 1L, LogPosition.UNSPECIFIED);
        }
        throw new IllegalArgumentException("Was expecting start record. Actual entry: " + start);
    }

    private static LogEntryChunkEnd createChunkEnd(LogEntry end, LogEntryChunkStart chunkStart) {
        if (end instanceof LogEntryChunkEnd) {
            LogEntryChunkEnd endChunk = (LogEntryChunkEnd)end;
            return endChunk;
        }
        if (end instanceof LogEntryCommit) {
            LogEntryCommit commit = (LogEntryCommit)end;
            return new LogEntryChunkEnd(commit.getTxId(), chunkStart.getChunkId(), commit.getChecksum());
        }
        throw new IllegalArgumentException("Was expecting end record. Actual entry: " + end);
    }
}

