/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.CheckpointLogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.v50.DetachedCheckpointLogEntryWriterV5_0;
import org.neo4j.kernel.impl.transaction.log.entry.v56.DetachedCheckpointLogEntryWriterV5_6;

public final class CheckpointWriters {
    private final DetachedCheckpointLogEntryWriterV5_0 writer5_0;
    private final DetachedCheckpointLogEntryWriterV5_6 writer5_6;

    public CheckpointWriters(WritableChecksumChannel channel) {
        this.writer5_0 = new DetachedCheckpointLogEntryWriterV5_0(channel);
        this.writer5_6 = new DetachedCheckpointLogEntryWriterV5_6(channel);
    }

    public CheckpointLogEntryWriter writer(KernelVersion version) {
        return switch (version) {
            case KernelVersion.V4_2, KernelVersion.V4_3_D4, KernelVersion.V4_4 -> throw new IllegalArgumentException("Unsupported kernel version for new checkpoint: " + version);
            case KernelVersion.V5_0 -> this.writer5_0;
            default -> this.writer5_6;
        };
    }
}

