/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.collection.trackable.HeapTrackingConcurrentLongObjectHashMap;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.kernel.impl.util.collection.ConcurrentBag;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class ConcurrentLongProbeTable<V extends Measurable>
extends DefaultCloseListenable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConcurrentLongProbeTable.class);
    private final MemoryTracker scopedMemoryTracker;
    private HeapTrackingConcurrentLongObjectHashMap<ConcurrentBag<V>> map;

    public static <V extends Measurable> ConcurrentLongProbeTable<V> createLongProbeTable(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new ConcurrentLongProbeTable<V>(scopedMemoryTracker);
    }

    private ConcurrentLongProbeTable(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.map = HeapTrackingConcurrentLongObjectHashMap.newMap((MemoryTracker)scopedMemoryTracker);
    }

    public void put(long key, V value) {
        MutableLong heapUsage = new MutableLong(value.estimatedHeapUsage() + ConcurrentBag.SIZE_OF_NODE);
        ((ConcurrentBag)this.map.computeIfAbsent(key, p -> {
            heapUsage.add(this.map.sizeOfWrapperObject() + ConcurrentBag.SIZE_OF_BAG);
            return new ConcurrentBag();
        })).add(value);
        this.scopedMemoryTracker.allocateHeap(heapUsage.longValue());
    }

    public Iterator<V> get(long key) {
        ConcurrentBag entry = (ConcurrentBag)this.map.get(key);
        if (entry == null) {
            return Collections.emptyIterator();
        }
        return entry.iterator();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void closeInternal() {
        if (this.map != null) {
            this.map = null;
            this.scopedMemoryTracker.close();
        }
    }

    public boolean isClosed() {
        return this.map == null;
    }
}

