/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanValue;
import org.neo4j.internal.index.label.LabelScanValueIndexAccessor;
import org.neo4j.internal.index.label.NativeLabelScanWriter;

class LabelScanValueIterator
extends LabelScanValueIndexAccessor
implements PrimitiveLongResourceIterator {
    private long fromId;
    private boolean hasNextDecided;
    private boolean hasNext;
    protected long next;

    LabelScanValueIterator(Seeker<LabelScanKey, LabelScanValue> cursor, long fromId) {
        super(cursor);
        this.fromId = fromId;
    }

    public boolean hasNext() {
        if (!this.hasNextDecided) {
            this.hasNext = this.fetchNext();
            this.hasNextDecided = true;
        }
        return this.hasNext;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements in " + this);
        }
        this.hasNextDecided = false;
        return this.next;
    }

    protected boolean fetchNext() {
        LabelScanKey key;
        while (true) {
            if (this.bits != 0L) {
                int delta = Long.numberOfTrailingZeros(this.bits);
                this.bits &= this.bits - 1L;
                this.next = this.baseNodeId + (long)delta;
                this.hasNext = true;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    this.close();
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            key = (LabelScanKey)this.cursor.key();
            this.baseNodeId = key.idRange * 64L;
            this.bits = ((LabelScanValue)this.cursor.value()).bits;
            if (this.fromId == -1L) continue;
            long range = NativeLabelScanWriter.rangeOf(this.fromId);
            if (range == key.idRange) {
                long relativeStartId = this.fromId % 64L;
                long mask = relativeStartId == 63L ? -1L : (1L << (int)(relativeStartId + 1L)) - 1L;
                this.bits &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.fromId = -1L;
            assert (this.keysInOrder(key));
        }
    }
}

