/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.index.label.AllEntriesLabelScanReader;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanKey;
import org.neo4j.internal.index.label.LabelScanLayout;
import org.neo4j.internal.index.label.LabelScanReader;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.LabelScanValue;
import org.neo4j.internal.index.label.LabelScanWriteMonitor;
import org.neo4j.internal.index.label.LabelScanWriter;
import org.neo4j.internal.index.label.NativeAllEntriesLabelScanReader;
import org.neo4j.internal.index.label.NativeLabelScanReader;
import org.neo4j.internal.index.label.NativeLabelScanWriter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.NodeLabelUpdate;
import org.neo4j.storageengine.api.NodeLabelUpdateListener;

public class NativeLabelScanStore
implements LabelScanStore,
NodeLabelUpdateListener {
    private static final byte CLEAN = 0;
    private static final byte NEEDS_REBUILDING = 1;
    private final boolean readOnly;
    private final LabelScanStore.Monitor monitor;
    private final Monitors monitors;
    private final PageCache pageCache;
    private final File storeFile;
    private final FullStoreChangeStream fullStoreChangeStream;
    private final FileSystemAbstraction fs;
    private final int pageSize;
    private final FileSystemAbstraction fileSystem;
    private final DatabaseLayout directoryStructure;
    private GBPTree<LabelScanKey, LabelScanValue> index;
    private boolean needsRebuild;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private NativeLabelScanWriter singleWriter;
    private NativeLabelScanWriter.WriteMonitor writeMonitor;
    private static final Consumer<PageCursor> needsRebuildingWriter = pageCursor -> pageCursor.putByte((byte)1);
    private static final Consumer<PageCursor> writeClean = pageCursor -> pageCursor.putByte((byte)0);

    public NativeLabelScanStore(PageCache pageCache, DatabaseLayout directoryStructure, FileSystemAbstraction fs, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this(pageCache, directoryStructure, fs, fullStoreChangeStream, readOnly, monitors, recoveryCleanupWorkCollector, 0);
    }

    NativeLabelScanStore(PageCache pageCache, DatabaseLayout directoryStructure, FileSystemAbstraction fs, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, int pageSize) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.pageSize = pageSize;
        this.fullStoreChangeStream = fullStoreChangeStream;
        this.directoryStructure = directoryStructure;
        this.storeFile = NativeLabelScanStore.getLabelScanStoreFile(directoryStructure);
        this.readOnly = readOnly;
        this.monitors = monitors;
        this.monitor = (LabelScanStore.Monitor)monitors.newMonitor(LabelScanStore.Monitor.class, new String[0]);
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.fileSystem = fs;
    }

    public static File getLabelScanStoreFile(DatabaseLayout directoryStructure) {
        return directoryStructure.labelScanStore();
    }

    @Override
    public LabelScanReader newReader() {
        return new NativeLabelScanReader(this.index);
    }

    @Override
    public LabelScanWriter newWriter() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create index writer in read only mode.");
        }
        try {
            return this.writer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void applyUpdates(Iterable<NodeLabelUpdate> labelUpdates) {
        try (LabelScanWriter writer = this.newWriter();){
            for (NodeLabelUpdate update : labelUpdates) {
                writer.write(update);
            }
        }
        catch (Exception e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    @Override
    public void force(IOLimiter limiter) {
        this.index.checkpoint(limiter);
        this.writeMonitor.force();
    }

    @Override
    public AllEntriesLabelScanReader allNodeLabelRanges() {
        return this.allNodeLabelRanges(0L, Long.MAX_VALUE);
    }

    @Override
    public AllEntriesLabelScanReader allNodeLabelRanges(long fromNodeId, long toNodeId) {
        IntFunction<Seeker<LabelScanKey, LabelScanValue>> seekProvider = labelId -> {
            try {
                return this.index.seek((Object)new LabelScanKey().set(labelId, fromNodeId / 64L), (Object)new LabelScanKey().set(labelId, (toNodeId - 1L) / 64L + 1L));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        int highestLabelId = -1;
        try (Seeker cursor = this.index.seek((Object)new LabelScanKey().set(Integer.MAX_VALUE, Long.MAX_VALUE), (Object)new LabelScanKey().set(0, -1L));){
            if (cursor.next()) {
                highestLabelId = ((LabelScanKey)cursor.key()).labelId;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NativeAllEntriesLabelScanReader(seekProvider, highestLabelId);
    }

    @Override
    public ResourceIterator<File> snapshotStoreFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.storeFile));
    }

    @Override
    public void init() throws IOException {
        boolean isDirty;
        this.monitor.init();
        boolean storeExists = this.hasStore();
        try {
            boolean bl = this.needsRebuild = !storeExists;
            if (!storeExists) {
                this.monitor.noIndex();
            }
            isDirty = this.instantiateTree();
        }
        catch (MetadataMismatchException e) {
            isDirty = true;
        }
        this.writeMonitor = LabelScanWriteMonitor.ENABLED ? new LabelScanWriteMonitor(this.fs, this.directoryStructure) : NativeLabelScanWriter.EMPTY;
        this.singleWriter = new NativeLabelScanWriter(1000, this.writeMonitor);
        if (isDirty) {
            this.monitor.notValidIndex();
            if (!this.readOnly) {
                this.dropStrict();
                this.instantiateTree();
            }
            this.needsRebuild = true;
        }
    }

    @Override
    public boolean hasStore() {
        return this.fileSystem.fileExists(this.storeFile);
    }

    @Override
    public File getLabelScanStoreFile() {
        return this.storeFile;
    }

    private boolean instantiateTree() {
        this.monitors.addMonitorListener((Object)this.treeMonitor(), new String[0]);
        GBPTree.Monitor monitor = (GBPTree.Monitor)this.monitors.newMonitor(GBPTree.Monitor.class, new String[0]);
        MutableBoolean isRebuilding = new MutableBoolean();
        Header.Reader readRebuilding = headerData -> isRebuilding.setValue(headerData.get() == 1);
        try {
            this.index = new GBPTree(this.pageCache, this.storeFile, (Layout)new LabelScanLayout(), this.pageSize, monitor, readRebuilding, needsRebuildingWriter, this.recoveryCleanupWorkCollector, this.readOnly, new OpenOption[0]);
            return isRebuilding.getValue();
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Label scan store file could not be found, most likely this database needs to be recovered, file:" + this.storeFile, e);
        }
    }

    private GBPTree.Monitor treeMonitor() {
        return new LabelIndexTreeMonitor();
    }

    @Override
    public void drop() throws IOException {
        try {
            this.dropStrict();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private void dropStrict() throws IOException {
        if (this.index != null) {
            this.index.close();
            this.index = null;
        }
        this.fileSystem.deleteFileOrThrow(this.storeFile);
    }

    @Override
    public void start() throws IOException {
        if (this.needsRebuild && !this.readOnly) {
            long numberOfNodes;
            this.monitor.rebuilding();
            try (NativeLabelScanWriter writer = this.writer();){
                numberOfNodes = this.fullStoreChangeStream.applyTo(writer);
            }
            this.index.checkpoint(IOLimiter.UNLIMITED, writeClean);
            this.monitor.rebuilt(numberOfNodes);
            this.needsRebuild = false;
        }
    }

    private NativeLabelScanWriter writer() throws IOException {
        return this.singleWriter.initialize((Writer<LabelScanKey, LabelScanValue>)this.index.writer());
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (Seeker cursor = this.index.seek((Object)new LabelScanKey(0, 0L), (Object)new LabelScanKey(Integer.MAX_VALUE, Long.MAX_VALUE));){
            boolean bl = !cursor.next();
            return bl;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() throws IOException {
        if (this.index != null) {
            this.index.close();
            this.index = null;
            this.writeMonitor.close();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirty() {
        return this.index == null || this.index.wasDirtyOnStartup();
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<LabelScanKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)));
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<LabelScanKey> visitor) {
        try {
            return this.index.consistencyCheck(visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class LabelIndexTreeMonitor
    extends GBPTree.Monitor.Adaptor {
        private LabelIndexTreeMonitor() {
        }

        public void cleanupRegistered() {
            NativeLabelScanStore.this.monitor.recoveryCleanupRegistered();
        }

        public void cleanupStarted() {
            NativeLabelScanStore.this.monitor.recoveryCleanupStarted();
        }

        public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            NativeLabelScanStore.this.monitor.recoveryCleanupFinished(numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
        }

        public void cleanupClosed() {
            NativeLabelScanStore.this.monitor.recoveryCleanupClosed();
        }

        public void cleanupFailed(Throwable throwable) {
            NativeLabelScanStore.this.monitor.recoveryCleanupFailed(throwable);
        }
    }
}

