/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.File;
import java.io.IOException;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.EmptyingRelationshipTypeScanStore;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.NativeLabelScanStore;
import org.neo4j.internal.index.label.NativeRelationshipTypeScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.EntityTokenUpdateListener;

public interface TokenScanStore
extends Lifecycle,
ConsistencyCheckable {
    public static final String LABEL_SCAN_STORE_MONITOR_TAG = "LabelScanStore";
    public static final String RELATIONSHIP_TYPE_SCAN_STORE_MONITOR_TAG = "RelationshipTypeScanStore";

    public static LabelScanStore labelScanStore(PageCache pageCache, DatabaseLayout directoryStructure, FileSystemAbstraction fs, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        return new NativeLabelScanStore(pageCache, directoryStructure, fs, fullStoreChangeStream, readOnly, monitors, recoveryCleanupWorkCollector, EntityType.NODE, cacheTracer, memoryTracker);
    }

    public static RelationshipTypeScanStore relationshipTypeScanStore(PageCache pageCache, DatabaseLayout directoryStructure, FileSystemAbstraction fs, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        return new NativeRelationshipTypeScanStore(pageCache, directoryStructure, fs, fullStoreChangeStream, readOnly, monitors, recoveryCleanupWorkCollector, EntityType.RELATIONSHIP, cacheTracer, memoryTracker);
    }

    public static RelationshipTypeScanStore toggledRelationshipTypeScanStore(PageCache pageCache, DatabaseLayout directoryStructure, FileSystemAbstraction fs, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        if (((Boolean)config.get(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store)).booleanValue()) {
            return TokenScanStore.relationshipTypeScanStore(pageCache, directoryStructure, fs, fullStoreChangeStream, readOnly, monitors, recoveryCleanupWorkCollector, cacheTracer, memoryTracker);
        }
        return new EmptyingRelationshipTypeScanStore(fs, directoryStructure, readOnly);
    }

    public EntityType entityType();

    public TokenScanReader newReader();

    public TokenScanWriter newWriter(PageCursorTracer var1);

    public TokenScanWriter newBulkAppendWriter(PageCursorTracer var1);

    public void force(IOLimiter var1, PageCursorTracer var2) throws IOException;

    public AllEntriesTokenScanReader allEntityTokenRanges(PageCursorTracer var1);

    public AllEntriesTokenScanReader allEntityTokenRanges(long var1, long var3, PageCursorTracer var5);

    public ResourceIterator<File> snapshotStoreFiles();

    public EntityTokenUpdateListener updateListener();

    public boolean isEmpty(PageCursorTracer var1) throws IOException;

    public void init() throws IOException;

    public void start() throws IOException;

    public void stop();

    public void shutdown() throws IOException;

    public void drop() throws IOException;

    public boolean isReadOnly();

    public static interface Monitor {
        public static final Monitor EMPTY = new Adaptor();

        public void init();

        public void noIndex();

        public void notValidIndex();

        public void rebuilding();

        public void rebuilt(long var1);

        public void recoveryCleanupRegistered();

        public void recoveryCleanupStarted();

        public void recoveryCleanupFinished(long var1, long var3, long var5, long var7);

        public void recoveryCleanupClosed();

        public void recoveryCleanupFailed(Throwable var1);

        public static class Adaptor
        implements Monitor {
            @Override
            public void init() {
            }

            @Override
            public void noIndex() {
            }

            @Override
            public void notValidIndex() {
            }

            @Override
            public void rebuilding() {
            }

            @Override
            public void rebuilt(long roughEntityCount) {
            }

            @Override
            public void recoveryCleanupRegistered() {
            }

            @Override
            public void recoveryCleanupStarted() {
            }

            @Override
            public void recoveryCleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            }

            @Override
            public void recoveryCleanupClosed() {
            }

            @Override
            public void recoveryCleanupFailed(Throwable throwable) {
            }
        }
    }
}

