/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.Args;
import org.neo4j.internal.index.label.NativeTokenScanWriter;
import org.neo4j.internal.index.label.TokenScanValue;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.PhysicalFlushableChannel;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.FeatureToggles;

public class TokenScanWriteMonitor
implements NativeTokenScanWriter.WriteMonitor {
    static final boolean ENABLED = FeatureToggles.flag(TokenScanWriteMonitor.class, (String)"enabled", (boolean)false);
    private static final long ROTATION_SIZE_THRESHOLD = FeatureToggles.getLong(TokenScanWriteMonitor.class, (String)"rotationThreshold", (long)ByteUnit.mebiBytes((long)200L));
    private static final long PRUNE_THRESHOLD = FeatureToggles.getLong(TokenScanWriteMonitor.class, (String)"pruneThreshold", (long)TimeUnit.DAYS.toMillis(2L));
    private static final byte TYPE_PREPARE_ADD = 0;
    private static final byte TYPE_PREPARE_REMOVE = 1;
    private static final byte TYPE_MERGE_ADD = 2;
    private static final byte TYPE_MERGE_REMOVE = 3;
    private static final byte TYPE_RANGE = 4;
    private static final byte TYPE_FLUSH = 5;
    private static final byte TYPE_SESSION_END = 6;
    private static final String ARG_TOFILE = "tofile";
    private static final String ARG_TXFILTER = "txfilter";
    private final FileSystemAbstraction fs;
    private final File storeDir;
    private final File file;
    private FlushableChannel channel;
    private final Lock lock = new ReentrantLock();
    private final LongAdder position = new LongAdder();
    private final long rotationThreshold;
    private final long pruneThreshold;

    TokenScanWriteMonitor(FileSystemAbstraction fs, DatabaseLayout databaseLayout, EntityType entityType) {
        this(fs, databaseLayout, ROTATION_SIZE_THRESHOLD, ByteUnit.Byte, PRUNE_THRESHOLD, TimeUnit.MILLISECONDS, entityType);
    }

    TokenScanWriteMonitor(FileSystemAbstraction fs, DatabaseLayout databaseLayout, long rotationThreshold, ByteUnit rotationThresholdUnit, long pruneThreshold, TimeUnit pruneThresholdUnit, EntityType entityType) {
        this.fs = fs;
        this.rotationThreshold = rotationThresholdUnit.toBytes(rotationThreshold);
        this.pruneThreshold = pruneThresholdUnit.toMillis(pruneThreshold);
        this.storeDir = databaseLayout.databaseDirectory();
        this.file = TokenScanWriteMonitor.writeLogBaseFile(databaseLayout, entityType);
        try {
            if (fs.fileExists(this.file)) {
                this.moveAwayFile();
            }
            this.channel = this.instantiateChannel();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static File writeLogBaseFile(DatabaseLayout databaseLayout, EntityType entityType) {
        File baseFile = entityType == EntityType.NODE ? databaseLayout.labelScanStore() : databaseLayout.relationshipTypeScanStore();
        return new File(baseFile + ".writelog");
    }

    private PhysicalFlushableChannel instantiateChannel() throws IOException {
        return new PhysicalFlushableChannel(this.fs.write(this.file), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Override
    public void range(long range, int tokenId) {
        try {
            this.channel.put((byte)4);
            this.channel.putLong(range);
            this.channel.putInt(tokenId);
            this.position.add(13L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void prepareAdd(long txId, int offset) {
        this.prepare((byte)0, txId, offset);
    }

    @Override
    public void prepareRemove(long txId, int offset) {
        this.prepare((byte)1, txId, offset);
    }

    private void prepare(byte type, long txId, int offset) {
        try {
            this.channel.put(type);
            this.channel.putLong(txId);
            this.channel.put((byte)offset);
            this.position.add(10L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void mergeAdd(TokenScanValue existingValue, TokenScanValue newValue) {
        this.merge((byte)2, existingValue, newValue);
    }

    @Override
    public void mergeRemove(TokenScanValue existingValue, TokenScanValue newValue) {
        this.merge((byte)3, existingValue, newValue);
    }

    private void merge(byte type, TokenScanValue existingValue, TokenScanValue newValue) {
        try {
            this.channel.put(type);
            this.channel.putLong(existingValue.bits);
            this.channel.putLong(newValue.bits);
            this.position.add(17L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flushPendingUpdates() {
        try {
            this.channel.put((byte)5);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeSessionEnded() {
        try {
            this.channel.put((byte)6);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.position.add(1L);
        if (this.position.sum() > this.rotationThreshold) {
            this.lock.lock();
            try {
                this.channel.prepareForFlush().flush();
                this.channel.close();
                this.moveAwayFile();
                this.position.reset();
                this.channel = this.instantiateChannel();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
            long time = System.currentTimeMillis();
            long threshold = time - this.pruneThreshold;
            for (File file : this.fs.listFiles(this.storeDir, (dir, name) -> name.startsWith(this.file.getName() + "-"))) {
                if (TokenScanWriteMonitor.millisOf(file) >= threshold) continue;
                this.fs.deleteFile(file);
            }
        }
    }

    static long millisOf(File file) {
        String name = file.getName();
        int dashIndex = name.lastIndexOf(45);
        if (dashIndex == -1) {
            return 0L;
        }
        return Long.parseLong(name.substring(dashIndex + 1));
    }

    @Override
    public void force() {
        this.lock.lock();
        try {
            this.channel.prepareForFlush().flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void moveAwayFile() throws IOException {
        File to;
        while (this.fs.fileExists(to = this.timestampedFile())) {
        }
        this.fs.renameFile(this.file, to, new CopyOption[0]);
    }

    private File timestampedFile() {
        return new File(this.storeDir, this.file.getName() + "-" + System.currentTimeMillis());
    }

    public static void main(String[] args) throws IOException {
        Args arguments = Args.withFlags((String[])new String[]{ARG_TOFILE}).parse(args);
        if (arguments.orphans().size() == 0) {
            System.err.println("Please supply database directory");
            return;
        }
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((File)new File((String)arguments.orphans().get(0)));
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        TxFilter txFilter = TokenScanWriteMonitor.parseTxFilter(arguments.get(ARG_TXFILTER, null));
        PrintStream out = System.out;
        boolean redirectsToFile = arguments.getBoolean(ARG_TOFILE);
        for (EntityType entityType : EntityType.values()) {
            if (redirectsToFile) {
                File outFile = new File(TokenScanWriteMonitor.writeLogBaseFile(databaseLayout, entityType).getAbsolutePath() + ".txt");
                System.out.println("Redirecting output to " + outFile);
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            PrintStreamDumper dumper = new PrintStreamDumper(out);
            TokenScanWriteMonitor.dump((FileSystemAbstraction)fs, databaseLayout, dumper, txFilter, entityType);
            if (!redirectsToFile) continue;
            out.close();
        }
    }

    public static void dump(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Dumper dumper, TxFilter txFilter, EntityType entityType) throws IOException {
        File writeLogFile = TokenScanWriteMonitor.writeLogBaseFile(databaseLayout, entityType);
        String writeLogFileBaseName = writeLogFile.getName();
        File[] files = fs.listFiles(databaseLayout.databaseDirectory(), (dir, name) -> name.startsWith(writeLogFileBaseName));
        Arrays.sort(files, Comparator.comparing(file -> file.getName().equals(writeLogFileBaseName) ? 0L : TokenScanWriteMonitor.millisOf(file)));
        long session = 0L;
        for (File file2 : files) {
            dumper.file(file2);
            session = TokenScanWriteMonitor.dumpFile(fs, file2, dumper, txFilter, session);
        }
    }

    private static long dumpFile(FileSystemAbstraction fs, File file, Dumper dumper, TxFilter txFilter, long session) throws IOException {
        try {
            ReadAheadChannel channel = new ReadAheadChannel(fs.read(file), (ScopedBuffer)new NativeScopedBuffer(ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            try {
                long range = -1L;
                int tokenId = -1;
                long flush = 0L;
                block13: while (true) {
                    byte type = channel.get();
                    switch (type) {
                        case 4: {
                            range = channel.getLong();
                            tokenId = channel.getInt();
                            if (txFilter == null) continue block13;
                            txFilter.clear();
                            continue block13;
                        }
                        case 0: 
                        case 1: {
                            TokenScanWriteMonitor.dumpPrepare(dumper, type, (ReadableChannel)channel, range, tokenId, txFilter, session, flush);
                            continue block13;
                        }
                        case 2: 
                        case 3: {
                            TokenScanWriteMonitor.dumpMerge(dumper, type, (ReadableChannel)channel, range, tokenId, txFilter, session, flush);
                            continue block13;
                        }
                        case 5: {
                            ++flush;
                            continue block13;
                        }
                        case 6: {
                            ++session;
                            flush = 0L;
                            continue block13;
                        }
                    }
                    System.out.println("Unknown type " + type + " at " + channel.position());
                }
            }
            catch (Throwable throwable) {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ReadPastEndException readPastEndException) {
            return session;
        }
    }

    private static void dumpMerge(Dumper dumper, byte type, ReadableChannel channel, long range, int tokenId, TxFilter txFilter, long session, long flush) throws IOException {
        long existingBits = channel.getLong();
        long newBits = channel.getLong();
        if (txFilter == null || txFilter.contains()) {
            dumper.merge(type == 2, session, flush, range, tokenId, existingBits, newBits);
        }
    }

    private static void dumpPrepare(Dumper dumper, byte type, ReadableChannel channel, long range, int tokenId, TxFilter txFilter, long session, long flush) throws IOException {
        long txId = channel.getLong();
        byte offset = channel.get();
        long entityId = range * 64L + (long)offset;
        if (txFilter == null || txFilter.contains(txId)) {
            dumper.prepare(type == 0, session, flush, txId, entityId, tokenId);
        }
    }

    static TxFilter parseTxFilter(String txFilter) {
        if (txFilter == null) {
            return null;
        }
        String[] tokens = txFilter.split(",");
        long[][] filters = new long[tokens.length][];
        for (int i = 0; i < tokens.length; ++i) {
            long low;
            long high;
            String token = tokens[i];
            int index = token.lastIndexOf(45);
            if (index == -1) {
                low = high = Long.parseLong(token);
            } else {
                low = Long.parseLong(token.substring(0, index));
                high = Long.parseLong(token.substring(index + 1));
            }
            filters[i] = new long[]{low, high};
        }
        return new TxFilter(filters);
    }

    public static class PrintStreamDumper
    implements Dumper {
        private final PrintStream out;
        private final char[] bitsAsChars = new char[71];

        PrintStreamDumper(PrintStream out) {
            this.out = out;
            Arrays.fill(this.bitsAsChars, ' ');
        }

        @Override
        public void file(File file) {
            this.out.println("=== " + file.getAbsolutePath() + " ===");
        }

        @Override
        public void prepare(boolean add, long session, long flush, long txId, long entityId, int tokenId) {
            this.out.println(String.format("[%d,%d]%stx:%d,entity:%d,token:%d", session, flush, Character.valueOf(add ? (char)'+' : '-'), txId, entityId, tokenId));
        }

        @Override
        public void merge(boolean add, long session, long flush, long range, int tokenId, long existingBits, long newBits) {
            this.out.println(String.format("[%d,%d]%srange:%d,tokenId:%d%n [%s]%n [%s]", session, flush, Character.valueOf(add ? (char)'+' : '-'), range, tokenId, PrintStreamDumper.bits(existingBits, this.bitsAsChars), PrintStreamDumper.bits(newBits, this.bitsAsChars)));
        }

        private static String bits(long bits, char[] bitsAsChars) {
            long mask = 1L;
            int i = 0;
            int c = 0;
            while (i < 64) {
                if (i % 8 == 0) {
                    ++c;
                }
                boolean set = (bits & mask) != 0L;
                bitsAsChars[bitsAsChars.length - c] = set ? 49 : 48;
                mask <<= 1;
                ++i;
                ++c;
            }
            return String.valueOf(bitsAsChars);
        }
    }

    public static interface Dumper {
        public void file(File var1);

        public void prepare(boolean var1, long var2, long var4, long var6, long var8, int var10);

        public void merge(boolean var1, long var2, long var4, long var6, int var8, long var9, long var11);
    }

    static class TxFilter {
        private final long[][] lowsAndHighs;
        private boolean contains;

        TxFilter(long[] ... lowsAndHighs) {
            this.lowsAndHighs = lowsAndHighs;
        }

        void clear() {
            this.contains = false;
        }

        boolean contains(long txId) {
            for (long[] filter : this.lowsAndHighs) {
                if (txId < filter[0] || txId > filter[1]) continue;
                this.contains = true;
                return true;
            }
            return false;
        }

        boolean contains() {
            return this.contains;
        }
    }
}

