/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.common.EntityType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.EntityTokenRange;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.TokenScan;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityTokenUpdateListener;

public final class EmptyingRelationshipTypeScanStore
implements RelationshipTypeScanStore {
    private final FileSystemAbstraction fileSystem;
    private final DatabaseLayout directoryStructure;
    private final boolean readOnly;

    public EmptyingRelationshipTypeScanStore(FileSystemAbstraction fileSystem, DatabaseLayout directoryStructure, boolean readOnly) {
        this.fileSystem = fileSystem;
        this.directoryStructure = directoryStructure;
        this.readOnly = readOnly;
    }

    @Override
    public EntityType entityType() {
        return EntityType.RELATIONSHIP;
    }

    @Override
    public TokenScanReader newReader() {
        return EmptyTokenScanReader.INSTANCE;
    }

    @Override
    public TokenScanWriter newWriter(PageCursorTracer cursorTracer) {
        return EmptyTokenScanWriter.INSTANCE;
    }

    @Override
    public TokenScanWriter newBulkAppendWriter(PageCursorTracer cursorTracer) {
        return EmptyTokenScanWriter.INSTANCE;
    }

    @Override
    public void force(IOLimiter limiter, PageCursorTracer cursorTracer) {
    }

    @Override
    public AllEntriesTokenScanReader allEntityTokenRanges(PageCursorTracer cursorTracer) {
        return EmptyAllEntriesTokenScanReader.INSTANCE;
    }

    @Override
    public AllEntriesTokenScanReader allEntityTokenRanges(long fromEntityId, long toEntityId, PageCursorTracer cursorTracer) {
        return EmptyAllEntriesTokenScanReader.INSTANCE;
    }

    @Override
    public ResourceIterator<Path> snapshotStoreFiles() {
        return Iterators.emptyResourceIterator();
    }

    @Override
    public EntityTokenUpdateListener updateListener() {
        return EmptyEntityTokenUpdateListener.INSTANCE;
    }

    @Override
    public boolean isEmpty(PageCursorTracer cursorTracer) {
        return true;
    }

    @Override
    public void init() {
        if (this.readOnly && this.fileSystem.fileExists(this.directoryStructure.relationshipTypeScanStore())) {
            throw new IllegalStateException("Database was started in read only mode and with relationship type scan store turned OFF, but relationship type scan store file still exists and cannot be deleted in read only mode. Please start database with relationship type scan store turned ON or without read only mode to let database delete the relationship type scan store safely. Note that consistency check use read only mode. Use setting 'unsupported.dbms.enable_relationship_type_scan_store' to turn relationship type scan store ON or OFF.");
        }
        this.fileSystem.deleteFile(this.directoryStructure.relationshipTypeScanStore());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void drop() {
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
        return true;
    }

    private static class EmptyTokenScan
    implements TokenScan {
        static final TokenScan INSTANCE = new EmptyTokenScan();

        private EmptyTokenScan() {
        }

        @Override
        public IndexProgressor initialize(IndexProgressor.EntityTokenClient client, IndexOrder indexOrder, PageCursorTracer cursorTracer) {
            return IndexProgressor.EMPTY;
        }

        @Override
        public IndexProgressor initializeBatch(IndexProgressor.EntityTokenClient client, int sizeHint, PageCursorTracer cursorTracer) {
            return IndexProgressor.EMPTY;
        }
    }

    private static class EmptyTokenScanReader
    implements TokenScanReader {
        static final TokenScanReader INSTANCE = new EmptyTokenScanReader();

        private EmptyTokenScanReader() {
        }

        @Override
        public PrimitiveLongResourceIterator entitiesWithToken(int tokenId, PageCursorTracer cursorTracer) {
            return PrimitiveLongResourceCollections.emptyIterator();
        }

        @Override
        public TokenScan entityTokenScan(int tokenId, PageCursorTracer cursorTracer) {
            return EmptyTokenScan.INSTANCE;
        }

        @Override
        public PrimitiveLongResourceIterator entitiesWithAnyOfTokens(long fromId, int[] tokenIds, PageCursorTracer cursorTracer) {
            return PrimitiveLongResourceCollections.emptyIterator();
        }
    }

    private static class EmptyTokenScanWriter
    implements TokenScanWriter {
        static final TokenScanWriter INSTANCE = new EmptyTokenScanWriter();

        private EmptyTokenScanWriter() {
        }

        @Override
        public void write(EntityTokenUpdate update) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class EmptyAllEntriesTokenScanReader
    implements AllEntriesTokenScanReader {
        static final AllEntriesTokenScanReader INSTANCE = new EmptyAllEntriesTokenScanReader();

        private EmptyAllEntriesTokenScanReader() {
        }

        @Override
        public int rangeSize() {
            return 0;
        }

        public long maxCount() {
            return 0L;
        }

        public void close() throws Exception {
        }

        public Iterator<EntityTokenRange> iterator() {
            return Collections.emptyIterator();
        }
    }

    private static class EmptyEntityTokenUpdateListener
    implements EntityTokenUpdateListener {
        static final EntityTokenUpdateListener INSTANCE = new EmptyEntityTokenUpdateListener();

        private EmptyEntityTokenUpdateListener() {
        }

        public void applyUpdates(Iterable<EntityTokenUpdate> labelUpdates, PageCursorTracer cursorTracer) {
        }
    }
}

