/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.util.List;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;

public interface FullStoreChangeStream {
    public static final FullStoreChangeStream EMPTY = (writer, cursorTracer, memoryTracker) -> 0L;

    public long applyTo(TokenScanWriter var1, PageCursorTracer var2, MemoryTracker var3) throws IOException;

    public static FullStoreChangeStream asStream(List<EntityTokenUpdate> existingData) {
        return (writer, cursorTracer, memoryTracker) -> {
            long count = 0L;
            for (EntityTokenUpdate update : existingData) {
                writer.write(update);
                ++count;
            }
            return count;
        };
    }
}

