/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.index.label.CompositeTokenScanValueIterator;
import org.neo4j.internal.index.label.NativeTokenScanWriter;
import org.neo4j.internal.index.label.TokenScan;
import org.neo4j.internal.index.label.TokenScanKey;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.internal.index.label.TokenScanValue;
import org.neo4j.internal.index.label.TokenScanValueIndexProgressor;
import org.neo4j.internal.index.label.TokenScanValueIterator;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.util.VisibleForTesting;

class NativeTokenScanReader
implements TokenScanReader {
    private final GBPTree<TokenScanKey, TokenScanValue> index;

    NativeTokenScanReader(GBPTree<TokenScanKey, TokenScanValue> index) {
        this.index = index;
    }

    @Override
    public PrimitiveLongResourceIterator entitiesWithToken(int tokenId, PageCursorTracer cursorTracer) {
        Seeker<TokenScanKey, TokenScanValue> cursor;
        try {
            cursor = this.seekerForToken(0L, tokenId, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new TokenScanValueIterator(cursor, -1L);
    }

    @Override
    public PrimitiveLongResourceIterator entitiesWithAnyOfTokens(long fromId, int[] tokenIds, PageCursorTracer cursorTracer) {
        List<PrimitiveLongResourceIterator> iterators = this.iteratorsForTokens(fromId, cursorTracer, tokenIds);
        return new CompositeTokenScanValueIterator(iterators, false);
    }

    @Override
    public TokenScan entityTokenScan(int tokenId, PageCursorTracer cursorTracer) {
        try {
            long highestEntityIdForToken = this.highestEntityIdForToken(tokenId, cursorTracer);
            return new NativeTokenScan(tokenId, highestEntityIdForToken);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private long highestEntityIdForToken(int tokenId, PageCursorTracer cursorTracer) throws IOException {
        try (Seeker seeker = this.index.seek((Object)new TokenScanKey(tokenId, Long.MAX_VALUE), (Object)new TokenScanKey(tokenId, Long.MIN_VALUE), cursorTracer);){
            long l = seeker.next() ? (((TokenScanKey)seeker.key()).idRange + 1L) * 64L : 0L;
            return l;
        }
    }

    private List<PrimitiveLongResourceIterator> iteratorsForTokens(long fromId, PageCursorTracer cursorTracer, int[] tokenIds) {
        ArrayList<PrimitiveLongResourceIterator> iterators = new ArrayList<PrimitiveLongResourceIterator>();
        try {
            for (int tokenId : tokenIds) {
                Seeker<TokenScanKey, TokenScanValue> cursor = this.seekerForToken(fromId, tokenId, cursorTracer);
                iterators.add(new TokenScanValueIterator(cursor, fromId));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return iterators;
    }

    private Seeker<TokenScanKey, TokenScanValue> seekerForToken(long startId, int tokenId, PageCursorTracer cursorTracer) throws IOException {
        return this.seekerForToken(startId, Long.MAX_VALUE, tokenId, IndexOrder.NONE, cursorTracer);
    }

    private Seeker<TokenScanKey, TokenScanValue> seekerForToken(long startId, long stopId, int tokenId, IndexOrder indexOrder, PageCursorTracer cursorTracer) throws IOException {
        long rangeTo;
        long rangeFrom;
        if (indexOrder != IndexOrder.DESCENDING) {
            rangeFrom = startId;
            rangeTo = stopId;
        } else {
            rangeFrom = stopId;
            rangeTo = startId;
        }
        TokenScanKey fromKey = new TokenScanKey(tokenId, NativeTokenScanWriter.rangeOf(rangeFrom));
        TokenScanKey toKey = new TokenScanKey(tokenId, NativeTokenScanWriter.rangeOf(rangeTo));
        return this.index.seek((Object)fromKey, (Object)toKey, cursorTracer);
    }

    @VisibleForTesting
    static long roundUp(long sizeHint) {
        return (sizeHint + 64L - 1L) / 64L * 64L;
    }

    private class NativeTokenScan
    implements TokenScan {
        private final AtomicLong nextStart;
        private final int tokenId;
        private final long max;

        NativeTokenScan(int tokenId, long max) {
            this.tokenId = tokenId;
            this.max = max;
            this.nextStart = new AtomicLong(0L);
        }

        @Override
        public IndexProgressor initialize(IndexProgressor.EntityTokenClient client, IndexOrder indexOrder, PageCursorTracer cursorTracer) {
            return this.init(client, Long.MIN_VALUE, Long.MAX_VALUE, indexOrder, cursorTracer);
        }

        @Override
        public IndexProgressor initializeBatch(IndexProgressor.EntityTokenClient client, int sizeHint, PageCursorTracer cursorTracer) {
            if (sizeHint == 0) {
                return IndexProgressor.EMPTY;
            }
            long size = NativeTokenScanReader.roundUp(sizeHint);
            long start = this.nextStart.getAndAdd(size);
            long stop = Math.min(start + size, this.max);
            if (start >= this.max) {
                return IndexProgressor.EMPTY;
            }
            return this.init(client, start, stop, IndexOrder.NONE, cursorTracer);
        }

        private IndexProgressor init(IndexProgressor.EntityTokenClient client, long start, long stop, IndexOrder indexOrder, PageCursorTracer cursorTracer) {
            Seeker<TokenScanKey, TokenScanValue> cursor;
            try {
                cursor = NativeTokenScanReader.this.seekerForToken(start, stop, this.tokenId, indexOrder, cursorTracer);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new TokenScanValueIndexProgressor(cursor, client, indexOrder);
        }
    }
}

