/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.index.label.TokenScanKey;
import org.neo4j.internal.index.label.TokenScanValue;
import org.neo4j.io.pagecache.PageCursor;

public class TokenScanLayout
extends Layout.Adapter<TokenScanKey, TokenScanValue> {
    private static final String IDENTIFIER_NAME = "LSL";
    private static final int KEY_SIZE = 10;

    public TokenScanLayout() {
        super(true, Layout.namedIdentifier((String)IDENTIFIER_NAME, (int)64), 0, 1);
    }

    public int compare(TokenScanKey o1, TokenScanKey o2) {
        int tokenComparison = Integer.compare(o1.tokenId, o2.tokenId);
        return tokenComparison != 0 ? tokenComparison : Long.compare(o1.idRange, o2.idRange);
    }

    public TokenScanKey newKey() {
        return new TokenScanKey();
    }

    public TokenScanKey copyKey(TokenScanKey key, TokenScanKey into) {
        into.tokenId = key.tokenId;
        into.idRange = key.idRange;
        return into;
    }

    public TokenScanValue newValue() {
        return new TokenScanValue();
    }

    public int keySize(TokenScanKey key) {
        return 10;
    }

    public int valueSize(TokenScanValue value) {
        return 8;
    }

    public void writeKey(PageCursor cursor, TokenScanKey key) {
        cursor.putInt(key.tokenId);
        TokenScanLayout.put6ByteLong(cursor, key.idRange);
    }

    private static void put6ByteLong(PageCursor cursor, long value) {
        cursor.putInt((int)value);
        cursor.putShort((short)(value >>> 32));
    }

    public void writeValue(PageCursor cursor, TokenScanValue value) {
        cursor.putLong(value.bits);
    }

    public void readKey(PageCursor cursor, TokenScanKey into, int keySize) {
        into.tokenId = cursor.getInt();
        into.idRange = TokenScanLayout.get6ByteLong(cursor);
    }

    private static long get6ByteLong(PageCursor cursor) {
        long low4b = (long)cursor.getInt() & 0xFFFFFFFFL;
        long high2b = cursor.getShort();
        return low4b | high2b << 32;
    }

    public void readValue(PageCursor cursor, TokenScanValue into, int valueSize) {
        into.bits = cursor.getLong();
    }

    public void initializeAsLowest(TokenScanKey key) {
        key.set(Integer.MIN_VALUE, Long.MIN_VALUE);
    }

    public void initializeAsHighest(TokenScanKey key) {
        key.set(Integer.MAX_VALUE, Long.MAX_VALUE);
    }
}

