/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import org.neo4j.storageengine.api.EntityTokenUpdate;

class PhysicalToLogicalTokenChanges {
    private PhysicalToLogicalTokenChanges() {
    }

    static void convertToAdditionsAndRemovals(EntityTokenUpdate update) {
        int beforeLength = update.getTokensBefore().length;
        int afterLength = update.getTokensAfter().length;
        int bc = 0;
        int ac = 0;
        long[] before = update.getTokensBefore();
        long[] after = update.getTokensAfter();
        int bi = 0;
        int ai = 0;
        while (bi < beforeLength || ai < afterLength) {
            long afterId;
            long beforeId = bi < beforeLength ? before[bi] : -1L;
            long l = afterId = ai < afterLength ? after[ai] : -1L;
            if (beforeId == afterId) {
                ++bi;
                ++ai;
                continue;
            }
            if (PhysicalToLogicalTokenChanges.smaller(beforeId, afterId)) {
                while (PhysicalToLogicalTokenChanges.smaller(beforeId, afterId) && bi < beforeLength) {
                    update.getTokensBefore()[bc++] = beforeId;
                    beforeId = ++bi < beforeLength ? before[bi] : -1L;
                }
                continue;
            }
            if (!PhysicalToLogicalTokenChanges.smaller(afterId, beforeId)) continue;
            while (PhysicalToLogicalTokenChanges.smaller(afterId, beforeId) && ai < afterLength) {
                update.getTokensAfter()[ac++] = afterId;
                afterId = ++ai < afterLength ? after[ai] : -1L;
            }
        }
        PhysicalToLogicalTokenChanges.terminateWithMinusOneIfNeeded(update.getTokensBefore(), bc);
        PhysicalToLogicalTokenChanges.terminateWithMinusOneIfNeeded(update.getTokensAfter(), ac);
    }

    private static boolean smaller(long id, long otherId) {
        return id != -1L && (otherId == -1L || id < otherId);
    }

    private static void terminateWithMinusOneIfNeeded(long[] tokenIds, int actualLength) {
        if (actualLength < tokenIds.length) {
            tokenIds[actualLength] = -1L;
        }
    }
}

