/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.BulkAppendNativeTokenScanWriter;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.NativeAllEntriesTokenScanReader;
import org.neo4j.internal.index.label.NativeTokenScanReader;
import org.neo4j.internal.index.label.NativeTokenScanWriter;
import org.neo4j.internal.index.label.TokenScanKey;
import org.neo4j.internal.index.label.TokenScanLayout;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.internal.index.label.TokenScanValue;
import org.neo4j.internal.index.label.TokenScanWriteMonitor;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityTokenUpdateListener;

public abstract class NativeTokenScanStore
implements TokenScanStore,
EntityTokenUpdateListener {
    private static final String TOKEN_SCAN_REBUILD_TAG = "tokenScanRebuild";
    private static final byte CLEAN = 0;
    private static final byte NEEDS_REBUILDING = 1;
    private final EntityType entityType;
    private final boolean readOnly;
    private final TokenScanStore.Monitor monitor;
    private final Monitors monitors;
    private final PageCache pageCache;
    private final Path storeFile;
    private final FullStoreChangeStream fullStoreChangeStream;
    private final FileSystemAbstraction fs;
    private final FileSystemAbstraction fileSystem;
    private final DatabaseLayout directoryStructure;
    private final PageCacheTracer cacheTracer;
    private final MemoryTracker memoryTracker;
    private GBPTree<TokenScanKey, TokenScanValue> index;
    private boolean needsRebuild;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private NativeTokenScanWriter singleWriter;
    private NativeTokenScanWriter.WriteMonitor writeMonitor;
    private final String tokenStoreName;
    private static final Consumer<PageCursor> needsRebuildingWriter = pageCursor -> pageCursor.putByte((byte)1);
    private static final Consumer<PageCursor> writeClean = pageCursor -> pageCursor.putByte((byte)0);

    NativeTokenScanStore(PageCache pageCache, DatabaseLayout directoryStructure, FileSystemAbstraction fs, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, EntityType entityType, PageCacheTracer cacheTracer, MemoryTracker memoryTracker, String tokenStoreName) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.fullStoreChangeStream = fullStoreChangeStream;
        this.directoryStructure = directoryStructure;
        this.cacheTracer = cacheTracer;
        this.memoryTracker = memoryTracker;
        boolean isLabelScanStore = entityType == EntityType.NODE;
        this.storeFile = isLabelScanStore ? directoryStructure.labelScanStore() : directoryStructure.relationshipTypeScanStore();
        this.readOnly = readOnly;
        this.monitors = monitors;
        String monitorTag = isLabelScanStore ? "LabelScanStore" : "RelationshipTypeScanStore";
        this.monitor = (TokenScanStore.Monitor)monitors.newMonitor(TokenScanStore.Monitor.class, new String[]{monitorTag});
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.fileSystem = fs;
        this.entityType = entityType;
        this.tokenStoreName = tokenStoreName;
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public TokenScanReader newReader() {
        return new NativeTokenScanReader(this.index);
    }

    @Override
    public TokenScanWriter newWriter(PageCursorTracer cursorTracer) {
        this.assertWritable();
        try {
            return this.writer(cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public TokenScanWriter newBulkAppendWriter(PageCursorTracer cursorTracer) {
        this.assertWritable();
        try {
            return new BulkAppendNativeTokenScanWriter((Writer<TokenScanKey, TokenScanValue>)this.index.writer(cursorTracer));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void assertWritable() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create index writer in read only mode.");
        }
    }

    public void applyUpdates(Iterable<EntityTokenUpdate> tokenUpdates, PageCursorTracer cursorTracer) {
        try (TokenScanWriter writer = this.newWriter(cursorTracer);){
            for (EntityTokenUpdate update : tokenUpdates) {
                writer.write(update);
            }
        }
        catch (Exception e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    @Override
    public void force(IOLimiter limiter, PageCursorTracer cursorTracer) {
        this.index.checkpoint(limiter, cursorTracer);
        this.writeMonitor.force();
    }

    @Override
    public AllEntriesTokenScanReader allEntityTokenRanges(PageCursorTracer cursorTracer) {
        return this.allEntityTokenRanges(0L, Long.MAX_VALUE, cursorTracer);
    }

    @Override
    public AllEntriesTokenScanReader allEntityTokenRanges(long fromEntityId, long toEntityId, PageCursorTracer cursorTracer) {
        IntFunction<Seeker<TokenScanKey, TokenScanValue>> seekProvider = tokenId -> {
            try {
                return this.index.seek((Object)new TokenScanKey().set(tokenId, fromEntityId / 64L), (Object)new TokenScanKey().set(tokenId, (toEntityId - 1L) / 64L + 1L), cursorTracer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        int highestTokenId = -1;
        try (Seeker cursor = this.index.seek((Object)new TokenScanKey().set(Integer.MAX_VALUE, Long.MAX_VALUE), (Object)new TokenScanKey().set(0, -1L), cursorTracer);){
            if (cursor.next()) {
                highestTokenId = ((TokenScanKey)cursor.key()).tokenId;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NativeAllEntriesTokenScanReader(seekProvider, highestTokenId, this.entityType);
    }

    @Override
    public ResourceIterator<Path> snapshotStoreFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.storeFile));
    }

    @Override
    public EntityTokenUpdateListener updateListener() {
        return this;
    }

    @Override
    public void init() throws IOException {
        boolean isDirty;
        this.monitor.init();
        boolean storeExists = this.hasStore();
        try {
            boolean bl = this.needsRebuild = !storeExists;
            if (!storeExists) {
                this.monitor.noIndex();
            }
            isDirty = this.instantiateTree();
        }
        catch (MetadataMismatchException e) {
            isDirty = true;
        }
        this.writeMonitor = TokenScanWriteMonitor.ENABLED ? new TokenScanWriteMonitor(this.fs, this.directoryStructure, this.entityType()) : NativeTokenScanWriter.EMPTY;
        this.singleWriter = new NativeTokenScanWriter(1000, this.writeMonitor);
        if (isDirty) {
            this.monitor.notValidIndex();
            if (!this.readOnly) {
                this.dropStrict();
                this.instantiateTree();
            }
            this.needsRebuild = true;
        }
    }

    private boolean hasStore() {
        return this.fileSystem.fileExists(this.storeFile);
    }

    private boolean instantiateTree() {
        this.monitors.addMonitorListener((Object)this.treeMonitor(), new String[0]);
        GBPTree.Monitor monitor = (GBPTree.Monitor)this.monitors.newMonitor(GBPTree.Monitor.class, new String[0]);
        MutableBoolean isRebuilding = new MutableBoolean();
        Header.Reader readRebuilding = headerData -> isRebuilding.setValue(headerData.get() == 1);
        try {
            this.index = new GBPTree(this.pageCache, this.storeFile, (Layout)new TokenScanLayout(), monitor, readRebuilding, needsRebuildingWriter, this.recoveryCleanupWorkCollector, this.readOnly, this.cacheTracer, Sets.immutable.empty(), this.tokenStoreName);
            return isRebuilding.getValue();
        }
        catch (TreeFileNotFoundException e) {
            String token = this.entityType == EntityType.NODE ? "Label" : "Relationship type";
            throw new IllegalStateException(token + " scan store file could not be found, most likely this database needs to be recovered, file:" + this.storeFile, e);
        }
    }

    private GBPTree.Monitor treeMonitor() {
        return new TokenIndexTreeMonitor();
    }

    @Override
    public void drop() throws IOException {
        try {
            this.dropStrict();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private void dropStrict() throws IOException {
        if (this.index != null) {
            this.index.close();
            this.index = null;
        }
        this.fileSystem.deleteFileOrThrow(this.storeFile);
    }

    @Override
    public void start() throws IOException {
        if (this.needsRebuild && !this.readOnly) {
            long numberOfEntities;
            this.monitor.rebuilding();
            PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(TOKEN_SCAN_REBUILD_TAG);
            try (TokenScanWriter writer = this.newBulkAppendWriter(cursorTracer);){
                numberOfEntities = this.fullStoreChangeStream.applyTo(writer, cursorTracer, this.memoryTracker);
            }
            this.index.checkpoint(IOLimiter.UNLIMITED, writeClean, cursorTracer);
            this.monitor.rebuilt(numberOfEntities);
            this.needsRebuild = false;
        }
    }

    private NativeTokenScanWriter writer(PageCursorTracer cursorTracer) throws IOException {
        return this.singleWriter.initialize((Writer<TokenScanKey, TokenScanValue>)this.index.writer(cursorTracer));
    }

    @Override
    public boolean isEmpty(PageCursorTracer cursorTracer) throws IOException {
        try (Seeker cursor = this.index.seek((Object)new TokenScanKey(0, 0L), (Object)new TokenScanKey(Integer.MAX_VALUE, Long.MAX_VALUE), cursorTracer);){
            boolean bl = !cursor.next();
            return bl;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() throws IOException {
        if (this.index != null) {
            this.index.close();
            this.index = null;
            this.writeMonitor.close();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<TokenScanKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)), cursorTracer);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<TokenScanKey> visitor, PageCursorTracer cursorTracer) {
        try {
            return this.index.consistencyCheck(visitor, cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class TokenIndexTreeMonitor
    extends GBPTree.Monitor.Adaptor {
        private TokenIndexTreeMonitor() {
        }

        public void cleanupRegistered() {
            NativeTokenScanStore.this.monitor.recoveryCleanupRegistered();
        }

        public void cleanupStarted() {
            NativeTokenScanStore.this.monitor.recoveryCleanupStarted();
        }

        public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            NativeTokenScanStore.this.monitor.recoveryCleanupFinished(numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
        }

        public void cleanupClosed() {
            NativeTokenScanStore.this.monitor.recoveryCleanupClosed();
        }

        public void cleanupFailed(Throwable throwable) {
            NativeTokenScanStore.this.monitor.recoveryCleanupFailed(throwable);
        }
    }
}

