/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.logging.Log;

public class LoggingMonitor
extends TokenScanStore.Monitor.Adaptor {
    private final Log log;
    private final EntityType type;
    private final String lowerToken;
    private final String upperToken;

    public LoggingMonitor(Log log, EntityType type) {
        this.log = log;
        this.type = type;
        this.lowerToken = type == EntityType.NODE ? "label" : "relationship type";
        this.upperToken = type == EntityType.NODE ? "Label" : "Relationship type";
    }

    @Override
    public void noIndex() {
        this.log.info("No %s index found, this might just be first use. Preparing to rebuild.", new Object[]{this.lowerToken});
    }

    @Override
    public void notValidIndex() {
        this.log.warn("%s index could not be read. Preparing to rebuild.", new Object[]{this.upperToken});
    }

    @Override
    public void rebuilding() {
        this.log.info("Rebuilding %s index, this may take a while", new Object[]{this.lowerToken});
    }

    @Override
    public void rebuilt(long roughEntityCount) {
        this.log.info("%s index rebuilt (roughly %d %ss)", new Object[]{this.upperToken, roughEntityCount, this.type.name().toLowerCase()});
    }

    @Override
    public void recoveryCleanupRegistered() {
        this.log.info("%s index cleanup job registered", new Object[]{this.upperToken});
    }

    @Override
    public void recoveryCleanupStarted() {
        this.log.info("%s index cleanup job started", new Object[]{this.upperToken});
    }

    @Override
    public void recoveryCleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
        StringJoiner joiner = new StringJoiner(", ", this.upperToken + " index cleanup job finished: ", "");
        joiner.add("Number of pages visited: " + numberOfPagesVisited);
        joiner.add("Number of tree nodes: " + numberOfTreeNodes);
        joiner.add("Number of cleaned crashed pointers: " + numberOfCleanedCrashPointers);
        joiner.add("Time spent: " + Format.duration((long)durationMillis));
        this.log.info(joiner.toString());
    }

    @Override
    public void recoveryCleanupClosed() {
        this.log.info("%s index cleanup job closed", new Object[]{this.upperToken});
    }

    @Override
    public void recoveryCleanupFailed(Throwable throwable) {
        this.log.info("%s index cleanup job failed.%nCaused by: %s", new Object[]{this.upperToken, ExceptionUtils.getStackTrace((Throwable)throwable)});
    }
}

