/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.Neo4jLayout;

public class DatabaseLayout {
    private static final String DATABASE_LOCK_FILENAME = "database_lock";
    private static final File[] EMPTY_FILES_ARRAY = new File[0];
    private final File databaseDirectory;
    private final Neo4jLayout neo4jLayout;
    private final String databaseName;

    public static DatabaseLayout ofFlat(File databaseDirectory) {
        File canonical = FileUtils.getCanonicalFile((File)databaseDirectory);
        File home = canonical.getParentFile();
        String dbName = canonical.getName();
        return Neo4jLayout.ofFlat(home).databaseLayout(dbName);
    }

    public static DatabaseLayout of(Config config) {
        return Neo4jLayout.of(config).databaseLayout((String)config.get(GraphDatabaseSettings.default_database));
    }

    static DatabaseLayout of(Neo4jLayout neo4jLayout, String databaseName) {
        return new DatabaseLayout(neo4jLayout, databaseName);
    }

    protected DatabaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        String normalizedName = new NormalizedDatabaseName(databaseName).name();
        this.neo4jLayout = neo4jLayout;
        this.databaseDirectory = FileUtils.getCanonicalFile((File)new File(neo4jLayout.databasesDirectory(), normalizedName));
        this.databaseName = normalizedName;
    }

    public File getTransactionLogsDirectory() {
        return new File(this.neo4jLayout.transactionLogsRootDirectory(), this.getDatabaseName());
    }

    public File databaseLockFile() {
        return new File(this.databaseDirectory(), DATABASE_LOCK_FILENAME);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Neo4jLayout getNeo4jLayout() {
        return this.neo4jLayout;
    }

    public File databaseDirectory() {
        return this.databaseDirectory;
    }

    public File metadataStore() {
        return this.file(DatabaseFile.METADATA_STORE.getName());
    }

    public File labelScanStore() {
        return this.file(DatabaseFile.LABEL_SCAN_STORE.getName());
    }

    public File countStore() {
        return this.file(DatabaseFile.COUNTS_STORE.getName());
    }

    public File propertyStringStore() {
        return this.file(DatabaseFile.PROPERTY_STRING_STORE.getName());
    }

    public File relationshipStore() {
        return this.file(DatabaseFile.RELATIONSHIP_STORE.getName());
    }

    public File propertyStore() {
        return this.file(DatabaseFile.PROPERTY_STORE.getName());
    }

    public File nodeStore() {
        return this.file(DatabaseFile.NODE_STORE.getName());
    }

    public File nodeLabelStore() {
        return this.file(DatabaseFile.NODE_LABEL_STORE.getName());
    }

    public File propertyArrayStore() {
        return this.file(DatabaseFile.PROPERTY_ARRAY_STORE.getName());
    }

    public File propertyKeyTokenStore() {
        return this.file(DatabaseFile.PROPERTY_KEY_TOKEN_STORE.getName());
    }

    public File propertyKeyTokenNamesStore() {
        return this.file(DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE.getName());
    }

    public File relationshipTypeTokenStore() {
        return this.file(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE.getName());
    }

    public File relationshipTypeTokenNamesStore() {
        return this.file(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE.getName());
    }

    public File labelTokenStore() {
        return this.file(DatabaseFile.LABEL_TOKEN_STORE.getName());
    }

    public File schemaStore() {
        return this.file(DatabaseFile.SCHEMA_STORE.getName());
    }

    public File relationshipGroupStore() {
        return this.file(DatabaseFile.RELATIONSHIP_GROUP_STORE.getName());
    }

    public File labelTokenNamesStore() {
        return this.file(DatabaseFile.LABEL_TOKEN_NAMES_STORE.getName());
    }

    public File indexStatisticsStore() {
        return this.file(DatabaseFile.INDEX_STATISTICS_STORE.getName());
    }

    public Set<File> idFiles() {
        return Arrays.stream(DatabaseFile.values()).filter(DatabaseFile::hasIdFile).flatMap(value -> this.idFile((DatabaseFile)((Object)value)).stream()).collect(Collectors.toSet());
    }

    public Set<File> storeFiles() {
        return Arrays.stream(DatabaseFile.values()).map(this::file).collect(Collectors.toSet());
    }

    public Optional<File> idFile(DatabaseFile file) {
        return file.hasIdFile() ? Optional.of(this.idFile(file.getName())) : Optional.empty();
    }

    public File file(String fileName) {
        return new File(this.databaseDirectory, fileName);
    }

    public File file(DatabaseFile databaseFile) {
        return this.file(databaseFile.getName());
    }

    public Stream<File> allFiles(DatabaseFile databaseFile) {
        return Stream.concat(this.idFile(databaseFile).stream(), Stream.of(this.file(databaseFile)));
    }

    public File[] listDatabaseFiles(FileFilter filter) {
        File[] files = this.databaseDirectory.listFiles(filter);
        return files != null ? files : EMPTY_FILES_ARRAY;
    }

    public File idMetadataStore() {
        return this.idFile(DatabaseFile.METADATA_STORE.getName());
    }

    public File idNodeStore() {
        return this.idFile(DatabaseFile.NODE_STORE.getName());
    }

    public File idNodeLabelStore() {
        return this.idFile(DatabaseFile.NODE_LABEL_STORE.getName());
    }

    public File idPropertyStore() {
        return this.idFile(DatabaseFile.PROPERTY_STORE.getName());
    }

    public File idPropertyKeyTokenStore() {
        return this.idFile(DatabaseFile.PROPERTY_KEY_TOKEN_STORE.getName());
    }

    public File idPropertyKeyTokenNamesStore() {
        return this.idFile(DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE.getName());
    }

    public File idPropertyStringStore() {
        return this.idFile(DatabaseFile.PROPERTY_STRING_STORE.getName());
    }

    public File idPropertyArrayStore() {
        return this.idFile(DatabaseFile.PROPERTY_ARRAY_STORE.getName());
    }

    public File idRelationshipStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_STORE.getName());
    }

    public File idRelationshipGroupStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_GROUP_STORE.getName());
    }

    public File idRelationshipTypeTokenStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE.getName());
    }

    public File idRelationshipTypeTokenNamesStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE.getName());
    }

    public File idLabelTokenStore() {
        return this.idFile(DatabaseFile.LABEL_TOKEN_STORE.getName());
    }

    public File idLabelTokenNamesStore() {
        return this.idFile(DatabaseFile.LABEL_TOKEN_NAMES_STORE.getName());
    }

    public File idSchemaStore() {
        return this.idFile(DatabaseFile.SCHEMA_STORE.getName());
    }

    private File idFile(String name) {
        return this.file(DatabaseLayout.idFileName(name));
    }

    private static String idFileName(String storeName) {
        return storeName + ".id";
    }

    public int hashCode() {
        return Objects.hash(this.databaseDirectory, this.neo4jLayout);
    }

    public String toString() {
        return "DatabaseLayout{databaseDirectory=" + this.databaseDirectory + ", transactionLogsDirectory=" + this.getTransactionLogsDirectory() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseLayout that = (DatabaseLayout)o;
        return Objects.equals(this.databaseDirectory, that.databaseDirectory) && Objects.equals(this.neo4jLayout, that.neo4jLayout) && this.getTransactionLogsDirectory().equals(that.getTransactionLogsDirectory());
    }
}

