/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.Neo4jLayout;

public class DatabaseLayout {
    private static final String DATABASE_LOCK_FILENAME = "database_lock";
    private static final String BACKUP_TOOLS_FOLDER = "tools";
    private static final String QUARANTINE_MARKER_FILENAME = "quarantine_marker";
    private final Path databaseDirectory;
    private final Neo4jLayout neo4jLayout;
    private final String databaseName;

    public static DatabaseLayout ofFlat(Path databaseDirectory) {
        Path canonical = FileUtils.getCanonicalFile((Path)databaseDirectory);
        Path home = canonical.getParent();
        String dbName = canonical.getFileName().toString();
        return Neo4jLayout.ofFlat(home).databaseLayout(dbName);
    }

    public static DatabaseLayout of(Config config) {
        return Neo4jLayout.of(config).databaseLayout((String)config.get(GraphDatabaseSettings.default_database));
    }

    public static DatabaseLayout of(Neo4jLayout neo4jLayout, String databaseName) {
        return new DatabaseLayout(neo4jLayout, databaseName);
    }

    protected DatabaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        String normalizedName = new NormalizedDatabaseName(databaseName).name();
        this.neo4jLayout = neo4jLayout;
        this.databaseDirectory = FileUtils.getCanonicalFile((Path)neo4jLayout.databasesDirectory().resolve(normalizedName));
        this.databaseName = normalizedName;
    }

    public Path getTransactionLogsDirectory() {
        return this.neo4jLayout.transactionLogsRootDirectory().resolve(this.getDatabaseName());
    }

    public Path getScriptDirectory() {
        return this.neo4jLayout.scriptRootDirectory().resolve(this.getDatabaseName());
    }

    public Path databaseLockFile() {
        return this.databaseDirectory().resolve(DATABASE_LOCK_FILENAME);
    }

    public Path quarantineMarkerFile() {
        return this.databaseDirectory().resolve(QUARANTINE_MARKER_FILENAME);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Neo4jLayout getNeo4jLayout() {
        return this.neo4jLayout;
    }

    public Path databaseDirectory() {
        return this.databaseDirectory;
    }

    public Path backupToolsFolder() {
        return this.databaseDirectory().resolve(BACKUP_TOOLS_FOLDER);
    }

    public Path metadataStore() {
        return this.file(DatabaseFile.METADATA_STORE.getName());
    }

    public Path labelScanStore() {
        return this.file(DatabaseFile.LABEL_SCAN_STORE.getName());
    }

    public Path relationshipTypeScanStore() {
        return this.file(DatabaseFile.RELATIONSHIP_TYPE_SCAN_STORE.getName());
    }

    public Path countStore() {
        return this.file(DatabaseFile.COUNTS_STORE.getName());
    }

    public Path relationshipGroupDegreesStore() {
        return this.file(DatabaseFile.RELATIONSHIP_GROUP_DEGREES_STORE.getName());
    }

    public Path propertyStringStore() {
        return this.file(DatabaseFile.PROPERTY_STRING_STORE.getName());
    }

    public Path relationshipStore() {
        return this.file(DatabaseFile.RELATIONSHIP_STORE.getName());
    }

    public Path propertyStore() {
        return this.file(DatabaseFile.PROPERTY_STORE.getName());
    }

    public Path nodeStore() {
        return this.file(DatabaseFile.NODE_STORE.getName());
    }

    public Path nodeLabelStore() {
        return this.file(DatabaseFile.NODE_LABEL_STORE.getName());
    }

    public Path propertyArrayStore() {
        return this.file(DatabaseFile.PROPERTY_ARRAY_STORE.getName());
    }

    public Path propertyKeyTokenStore() {
        return this.file(DatabaseFile.PROPERTY_KEY_TOKEN_STORE.getName());
    }

    public Path propertyKeyTokenNamesStore() {
        return this.file(DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE.getName());
    }

    public Path relationshipTypeTokenStore() {
        return this.file(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE.getName());
    }

    public Path relationshipTypeTokenNamesStore() {
        return this.file(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE.getName());
    }

    public Path labelTokenStore() {
        return this.file(DatabaseFile.LABEL_TOKEN_STORE.getName());
    }

    public Path schemaStore() {
        return this.file(DatabaseFile.SCHEMA_STORE.getName());
    }

    public Path relationshipGroupStore() {
        return this.file(DatabaseFile.RELATIONSHIP_GROUP_STORE.getName());
    }

    public Path labelTokenNamesStore() {
        return this.file(DatabaseFile.LABEL_TOKEN_NAMES_STORE.getName());
    }

    public Path indexStatisticsStore() {
        return this.file(DatabaseFile.INDEX_STATISTICS_STORE.getName());
    }

    public Set<Path> idFiles() {
        return Arrays.stream(DatabaseFile.values()).filter(DatabaseFile::hasIdFile).flatMap(value -> this.idFile((DatabaseFile)((Object)value)).stream()).collect(Collectors.toSet());
    }

    public Set<Path> storeFiles() {
        return Arrays.stream(DatabaseFile.values()).map(this::file).collect(Collectors.toSet());
    }

    public Optional<Path> idFile(DatabaseFile file) {
        return file.hasIdFile() ? Optional.of(this.idFile(file.getName())) : Optional.empty();
    }

    public Path file(String fileName) {
        return this.databaseDirectory.resolve(fileName);
    }

    public Path file(DatabaseFile databaseFile) {
        return this.file(databaseFile.getName());
    }

    public Stream<Path> allFiles(DatabaseFile databaseFile) {
        return Stream.concat(this.idFile(databaseFile).stream(), Stream.of(this.file(databaseFile)));
    }

    public Path[] listDatabaseFiles(Predicate<? super Path> filter) {
        Path[] pathArray;
        block8: {
            Stream<Path> list = Files.list(this.databaseDirectory);
            try {
                pathArray = (Path[])list.filter(filter).toArray(Path[]::new);
                if (list == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            list.close();
        }
        return pathArray;
    }

    public Path idNodeStore() {
        return this.idFile(DatabaseFile.NODE_STORE.getName());
    }

    public Path idNodeLabelStore() {
        return this.idFile(DatabaseFile.NODE_LABEL_STORE.getName());
    }

    public Path idPropertyStore() {
        return this.idFile(DatabaseFile.PROPERTY_STORE.getName());
    }

    public Path idPropertyKeyTokenStore() {
        return this.idFile(DatabaseFile.PROPERTY_KEY_TOKEN_STORE.getName());
    }

    public Path idPropertyKeyTokenNamesStore() {
        return this.idFile(DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE.getName());
    }

    public Path idPropertyStringStore() {
        return this.idFile(DatabaseFile.PROPERTY_STRING_STORE.getName());
    }

    public Path idPropertyArrayStore() {
        return this.idFile(DatabaseFile.PROPERTY_ARRAY_STORE.getName());
    }

    public Path idRelationshipStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_STORE.getName());
    }

    public Path idRelationshipGroupStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_GROUP_STORE.getName());
    }

    public Path idRelationshipTypeTokenStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE.getName());
    }

    public Path idRelationshipTypeTokenNamesStore() {
        return this.idFile(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE.getName());
    }

    public Path idLabelTokenStore() {
        return this.idFile(DatabaseFile.LABEL_TOKEN_STORE.getName());
    }

    public Path idLabelTokenNamesStore() {
        return this.idFile(DatabaseFile.LABEL_TOKEN_NAMES_STORE.getName());
    }

    public Path idSchemaStore() {
        return this.idFile(DatabaseFile.SCHEMA_STORE.getName());
    }

    private Path idFile(String name) {
        return this.file(DatabaseLayout.idFileName(name));
    }

    private static String idFileName(String storeName) {
        return storeName + ".id";
    }

    public int hashCode() {
        return Objects.hash(this.databaseDirectory, this.neo4jLayout);
    }

    public String toString() {
        return "DatabaseLayout{databaseDirectory=" + this.databaseDirectory + ", transactionLogsDirectory=" + this.getTransactionLogsDirectory() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseLayout that = (DatabaseLayout)o;
        return Objects.equals(this.databaseDirectory, that.databaseDirectory) && Objects.equals(this.neo4jLayout, that.neo4jLayout) && this.getTransactionLogsDirectory().equals(that.getTransactionLogsDirectory());
    }
}

