/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import java.util.Objects;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;

abstract class AbstractLockService<HANDLE>
implements LockService {
    AbstractLockService() {
    }

    @Override
    public Lock acquireNodeLock(long nodeId, LockType type) {
        return this.lock(new LockedNode(nodeId));
    }

    @Override
    public Lock acquireRelationshipLock(long relationshipId, LockType type) {
        return this.lock(new LockedRelationship(relationshipId));
    }

    @Override
    public Lock acquireCustomLock(int resourceType, long id, LockType type) {
        return this.lock(new CustomLockedEntity(resourceType, id));
    }

    private Lock lock(LockedEntity key) {
        return new LockReference(key, this.acquire(key));
    }

    protected abstract HANDLE acquire(LockedEntity var1);

    protected abstract void release(LockedEntity var1, HANDLE var2);

    private static class CustomLockedEntity
    extends LockedEntity {
        private final int type;

        private CustomLockedEntity(int type, long id) {
            super(id);
            this.type = type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type, this.id);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CustomLockedEntity that = (CustomLockedEntity)obj;
            return this.type == that.type;
        }
    }

    static final class LockedRelationship
    extends LockedEntity {
        LockedRelationship(long relationshipId) {
            super(relationshipId);
        }
    }

    static final class LockedNode
    extends LockedEntity {
        LockedNode(long nodeId) {
            super(nodeId);
        }
    }

    private class LockReference
    extends Lock {
        private final LockedEntity key;
        private HANDLE handle;

        LockReference(LockedEntity key, HANDLE handle) {
            this.key = key;
            this.handle = handle;
        }

        public String toString() {
            StringBuilder repr = new StringBuilder(this.key.getClass().getSimpleName()).append('[');
            this.key.toString(repr);
            if (this.handle != null) {
                repr.append("; HELD_BY=").append(this.handle);
            } else {
                repr.append("; RELEASED");
            }
            return repr.append(']').toString();
        }

        @Override
        public void release() {
            if (this.handle == null) {
                return;
            }
            try {
                AbstractLockService.this.release(this.key, this.handle);
            }
            finally {
                this.handle = null;
            }
        }
    }

    protected static abstract class LockedEntity {
        final long id;

        private LockedEntity(long id) {
            this.id = id;
        }

        public final String toString() {
            StringBuilder repr = new StringBuilder(this.getClass().getSimpleName()).append('[');
            this.toString(repr);
            return repr.append(']').toString();
        }

        void toString(StringBuilder repr) {
            repr.append("id=").append(this.id);
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass().equals(this.getClass())) {
                LockedEntity that = (LockedEntity)obj;
                return this.id == that.id;
            }
            return false;
        }
    }
}

