/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class LeaseException
extends GqlRuntimeException
implements Status.HasStatus {
    private final Status status;
    private static final String NOT_ON_LEADER_ERROR_MESSAGE = "Should only attempt to acquire lease when leader.";

    @Deprecated
    public LeaseException(String message, Status status) {
        this(message, null, status);
    }

    private LeaseException(ErrorGqlStatusObject gqlStatusObject, String message, Status status) {
        this(gqlStatusObject, message, null, status);
    }

    @Deprecated
    public LeaseException(String message, Throwable cause, Status status) {
        super(message, cause);
        this.status = status;
    }

    private LeaseException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause, Status status) {
        super(gqlStatusObject, message, cause);
        this.status = status;
    }

    public static LeaseException failedToAcquireLease(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N33).withClassification((GqlClassification)ErrorClassification.TRANSIENT_ERROR).build();
        return new LeaseException(gql, "Failed to acquire lease", cause, (Status)Status.Cluster.ReplicationFailure);
    }

    public static LeaseException localInstanceLostLease() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N07).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new LeaseException(gql, "Local instance lost lease.", (Status)Status.Cluster.NotALeader);
    }

    public static LeaseException takenByAnotherCandidate() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N07).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new LeaseException(gql, "Failed to acquire lease since it was taken by another candidate", (Status)Status.Cluster.NotALeader);
    }

    public static LeaseException notOnALeader() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N07).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new LeaseException(gql, NOT_ON_LEADER_ERROR_MESSAGE, (Status)Status.Cluster.NotALeader);
    }

    public Status status() {
        return this.status;
    }
}

