/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.internal.helpers.VarHandleUtils;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.lock.LockType;

class SharedLock
implements ForsetiLockManager.Lock {
    private static final int UPDATE_LOCK_FLAG = Integer.MIN_VALUE;
    private volatile int refCount = 1;
    private static final VarHandle REF_COUNT = VarHandleUtils.getVarHandle((MethodHandles.Lookup)MethodHandles.lookup(), (String)"refCount");
    private final ConcurrentHashMap.KeySetView<ForsetiClient, Boolean> clientsHoldingThisLock = ConcurrentHashMap.newKeySet();

    SharedLock(ForsetiClient client) {
        this.clientsHoldingThisLock.add(client);
    }

    public boolean acquire(ForsetiClient client) {
        if (!this.acquireReference()) {
            return false;
        }
        if (this.clientsHoldingThisLock.add(client)) {
            return true;
        }
        this.releaseReference();
        return false;
    }

    public boolean release(ForsetiClient client) {
        this.removeClientHoldingLock(client);
        return this.releaseReference();
    }

    @Override
    public void copyHolderWaitListsInto(Set<ForsetiClient> waitList) {
        for (ForsetiClient client : this.clientsHoldingThisLock) {
            client.copyWaitListTo(waitList);
        }
    }

    @Override
    public ForsetiClient detectDeadlock(ForsetiClient clientId) {
        if (!this.isClosed()) {
            for (ForsetiClient client : this.clientsHoldingThisLock) {
                if (!client.isWaitingFor(clientId)) continue;
                return client;
            }
        }
        return null;
    }

    boolean tryAcquireUpdateLock() {
        return (REF_COUNT.getAndBitwiseOr(this, Integer.MIN_VALUE) & Integer.MIN_VALUE) == 0;
    }

    void releaseUpdateLock() {
        VarHandleUtils.consumeInt((int)REF_COUNT.getAndBitwiseAnd(this, Integer.MAX_VALUE));
    }

    int numberOfHolders() {
        return this.refCount & Integer.MAX_VALUE;
    }

    boolean isUpdateLock() {
        return (this.refCount & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @Override
    public String describeWaitList() {
        return this.clientsHoldingThisLock.stream().map(ForsetiClient::describeWaitList).collect(Collectors.joining(", ", "SharedLock[", "]"));
    }

    @Override
    public void collectOwners(Set<ForsetiClient> owners) {
        owners.addAll(this.clientsHoldingThisLock);
    }

    @Override
    public boolean isOwnedBy(ForsetiClient client) {
        return this.clientsHoldingThisLock.contains(client);
    }

    @Override
    public LockType type() {
        return this.isUpdateLock() && this.numberOfHolders() <= 1 ? LockType.EXCLUSIVE : LockType.SHARED;
    }

    @Override
    public LongSet transactionIds() {
        HashSet<ForsetiClient> lockClients = new HashSet<ForsetiClient>();
        this.collectOwners(lockClients);
        return LongSets.immutable.ofAll(lockClients.stream().mapToLong(ForsetiClient::transactionId));
    }

    @Override
    public boolean isClosed() {
        return this.numberOfHolders() == 0;
    }

    public String toString() {
        int refCount;
        String specificLockType;
        StringBuilder owners = new StringBuilder();
        for (ForsetiClient forsetiClient : this.clientsHoldingThisLock) {
            if (owners.length() > 0) {
                owners.append(", ");
            }
            owners.append(forsetiClient);
        }
        if (this.isUpdateLock()) {
            specificLockType = "UpdateLock";
            refCount = this.numberOfHolders();
        } else {
            specificLockType = "SharedLock";
            refCount = this.refCount;
        }
        return String.format("%s{owners=%s, refCount=%d}", specificLockType, owners, refCount);
    }

    private void removeClientHoldingLock(ForsetiClient client) {
        if (!this.clientsHoldingThisLock.remove(client)) {
            throw new IllegalStateException(client + " asked to be removed from holder list, but it does not hold " + this);
        }
    }

    private boolean acquireReference() {
        int refs;
        while ((refs = this.refCount) > 0) {
            if (!REF_COUNT.weakCompareAndSet(this, refs, refs + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean releaseReference() {
        int newRefCount;
        int refAndUpdateFlag;
        while (!REF_COUNT.weakCompareAndSet(this, refAndUpdateFlag = this.refCount, (newRefCount = (refAndUpdateFlag & Integer.MAX_VALUE) - 1) | refAndUpdateFlag & Integer.MIN_VALUE)) {
        }
        return newRefCount == 0;
    }
}

