/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;

public final class LockClientStateHolder {
    private static final int FLAG_BITS = 2;
    private static final int CLIENT_BITS = 30;
    private static final int STOPPED = 0x40000000;
    private static final int PREPARE = 0x20000000;
    private static final int STATE_BIT_MASK = 0x60000000;
    private static final int INITIAL_STATE = 0;
    private final AtomicInteger clientState = new AtomicInteger(0);

    public boolean hasActiveClients() {
        return LockClientStateHolder.getActiveClients(this.clientState.get()) > 0;
    }

    public boolean isSingleClient() {
        return LockClientStateHolder.getActiveClients(this.clientState.get()) == 1;
    }

    public void prepare(Locks.Client client) {
        int newValue;
        int currentValue;
        do {
            if (!LockClientStateHolder.isStopped(currentValue = this.clientState.get())) continue;
            throw new LockClientStoppedException(client);
        } while (!this.clientState.compareAndSet(currentValue, newValue = LockClientStateHolder.stateWithNewStatus(currentValue, 0x20000000)));
    }

    public boolean stopClient() {
        int newValue;
        int currentValue;
        do {
            if (LockClientStateHolder.isPrepare(currentValue = this.clientState.get())) {
                return false;
            }
            if (!LockClientStateHolder.isStopped(currentValue)) continue;
            return false;
        } while (!this.clientState.compareAndSet(currentValue, newValue = LockClientStateHolder.stateWithNewStatus(currentValue, 0x40000000)));
        return true;
    }

    public void closeClient() {
        int newValue;
        int currentValue;
        while (!this.clientState.compareAndSet(currentValue = this.clientState.get(), newValue = LockClientStateHolder.stateWithNewStatus(currentValue, 0x40000000))) {
        }
    }

    public void incrementActiveClients(Locks.Client client) {
        int currentState;
        do {
            if (!LockClientStateHolder.isStopped(currentState = this.clientState.get())) continue;
            throw new LockClientStoppedException(client);
        } while (!this.clientState.compareAndSet(currentState, LockClientStateHolder.incrementActiveClients(currentState)));
    }

    public void decrementActiveClients() {
        int currentState;
        while (!this.clientState.compareAndSet(currentState = this.clientState.get(), LockClientStateHolder.decrementActiveClients(currentState))) {
        }
    }

    public boolean isStopped() {
        return LockClientStateHolder.isStopped(this.clientState.get());
    }

    public boolean isPrepared() {
        return LockClientStateHolder.isPrepare(this.clientState.get());
    }

    public void reset() {
        this.clientState.set(0);
    }

    private static boolean isPrepare(int clientState) {
        return LockClientStateHolder.getStatus(clientState) == 0x20000000;
    }

    private static boolean isStopped(int clientState) {
        return LockClientStateHolder.getStatus(clientState) == 0x40000000;
    }

    private static int getStatus(int clientState) {
        return clientState & 0x60000000;
    }

    private static int getActiveClients(int clientState) {
        return clientState & 0x9FFFFFFF;
    }

    private static int stateWithNewStatus(int clientState, int newStatus) {
        return newStatus | LockClientStateHolder.getActiveClients(clientState);
    }

    private static int incrementActiveClients(int clientState) {
        return LockClientStateHolder.getStatus(clientState) | Math.incrementExact(LockClientStateHolder.getActiveClients(clientState));
    }

    private static int decrementActiveClients(int clientState) {
        return LockClientStateHolder.getStatus(clientState) | Math.decrementExact(LockClientStateHolder.getActiveClients(clientState));
    }
}

